% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createStability.R
\name{plot.stability}
\alias{plot.stability}
\title{Plot function for class stability}
\usage{
\method{plot}{stability}(
  x,
  ...,
  colorGenoBy = NULL,
  colGeno = NULL,
  title = paste("Stability coefficients for", x$trait),
  output = TRUE
)
}
\arguments{
\item{x}{An object of class stability.}

\item{...}{Not used.}

\item{colorGenoBy}{A character string indicating a column in the \code{TD}
used as input for the stability analysis by which the genotypes should be
colored. If \code{NULL} all genotypes will be colored black.}

\item{colGeno}{A character vector with plot colors for the genotypes. A
single color when \code{colorGenoBy = NULL}, a vector of colors otherwise.}

\item{title}{A character string used a title for the plot.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a list of ggplot objects is invisibly returned.}
}
\value{
A list of ggplot object is invisibly returned.
}
\description{
Function for creating scatter plots of the square roots of the computed
stability measures against the means.
}
\examples{
## Compute three stability measures for TDMaize.
geStab <- gxeStability(TD = TDMaize, trait = "yld")

## Create scatter plots of the computed stability measures against the means.
plot(geStab)

}
\seealso{
Other stability: 
\code{\link{gxeStability}()},
\code{\link{report.stability}()}
}
\concept{stability}
