% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runme.R
\name{crmda_html_document}
\alias{crmda_html_document}
\title{Custom output_format object to make MathJax work with custom HTML template}
\usage{
crmda_html_document(template = "theme/guide-template.html", ...)
}
\arguments{
\item{template}{Name of template file.}

\item{...}{Any arguments passed along to html_document in
rmarkdown}
}
\value{
html_document object with custom template
}
\description{
The \code{rmarkdown::html_document} fails to use MathJax if a custom HTML
template is supplied. This is described here
\url{https://github.com/rstudio/rmarkdown/issues/727}.  The workaround
is to provide this wrapper.
}
\details{
This function is needed only so as to "fool" pandoc in order to
make an HTML document compatible with MathJax. See the example
files created by \code{initWriteup("rmd2html-guide")} for a usage
example.
}
\examples{
tdir <- tempdir()
doctype <- "rmd2html-guide"
dirout <- initWriteup(doctype, dir = file.path(tdir, doctype))
list.files(dirout)
MESSG <- paste("Inspect the YAML header output section of 'skeleton.Rmd'.",
               "It makes use of 'crmda_html_document'.")
cat(MESSG)
}
\author{
Paul Johnson
}
