% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invLogitAdj.r
\name{invLogitAdj}
\alias{invLogitAdj}
\title{Inverse logit is robust to cases that equal 0 or 1}
\usage{
invLogitAdj(x, epsilon = 0.01, base = 10, auto = FALSE)
}
\arguments{
\item{x}{Numeric vector.}

\item{epsilon}{Value or character. If a numeric value (typically ~0.01 or smaller), then this is added/subtracted from \code{x} to ensure log of 0 or 1 is not taken. If equal to \code{'auto'} then the value of \code{epsilon} is taken from the attributes of \code{x}. If \code{x} has no such attribute, a warning is given and a value of 0.01 is used.}

\item{base}{Base of logarithm. Use \code{base=exp(1)} for base \code{e}.}

\item{auto}{If \code{TRUE} then if the attributes of \code{x} have slots named \code{epsilon} and \code{base} then use these instead of the user-supplied values of \code{epsilon} and \code{base}. If they do not appear as attributes of \code{x} but \code{auto} is \code{TRUE} then the function prints warnings and uses 0.01 and 10, respectively. If \code{FALSE} (default) then use the user-supplied values of \code{epsilon} and \code{base}.}
}
\value{
Numeric.
}
\description{
This function is the inverse of \code{\link[statisfactory]{logitAdj}}. That function calculates the logit of values but is robust to cases where the operand is 0 or 1. The adjusted inverse logit is equal to \code{(base^x + epsilon * base^x - epsilon) / (base^x + 1)}.
}
\examples{

x <- seq(0, 1, by=0.1)
y <- logitAdj(x)
xx <- invLogitAdj(y, auto = TRUE)

}
\seealso{
\code{\link[statisfactory]{logitAdj}}
}
