% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.utilities.R
\name{append.rhs.formula}
\alias{append.rhs.formula}
\alias{nonsimp.update.formula}
\alias{term.list.formula}
\title{Functions for Querying, Validating and Extracting from ERGM Formulas}
\usage{
append.rhs.formula(object, newterms, keep.onesided = FALSE)

nonsimp.update.formula(object, new, ..., from.new = FALSE)

term.list.formula(rhs, sign = +1)
}
\arguments{
\item{object}{formula object to be updated}

\item{newterms}{list of terms (names) to append to the formula, or a formula
whose RHS terms will be used}

\item{keep.onesided}{if the initial formula is one-sided, keep it whether to
keep it one-sided or whether to make the initial formula the new LHS}

\item{new}{new formula to be used in updating}

\item{\dots}{Additional arguments. Currently unused.}

\item{from.new}{logical or character vector of variable names. controls how
environment of formula gets updated.}

\item{rhs}{a formula-style call containing the right hand side of formula,
obtained by \code{fmla[[3]]} for a two-sided formula and \code{fmla[[2]]}
for a one-sided formula.}

\item{sign}{an internal parameter used by \code{term.list.formula} when
calling itself recursively.}
}
\value{
\code{append.rhs.formula} each return an
updated formula object

\code{nonsimp.update.formula} each return an
updated formula object

\code{terms.list.formula} returns a list of formula terms, with an additional numerical vector attribute \code{"sign"} with of the same length, giving the corresponding term's sign as \code{+1} or \code{-1}.
}
\description{
\code{append.rhs.formula} appends a list of terms to the RHS of a
formula. If the formula is one-sided, the RHS becomes the LHS, if
\code{keep.onesided==FALSE} (the default).
}
\section{Functions}{
\itemize{
\item \code{nonsimp.update.formula}: \code{nonsimp.update.formula} is a reimplementation of
\code{\link{update.formula}} that does not simplify.  Note that the
resulting formula's environment is set as follows. If
\code{from.new==FALSE}, it is set to that of object. Otherwise, a new
sub-environment of object, containing, in addition, variables in new listed
in from.new (if a character vector) or all of new (if TRUE).

\item \code{term.list.formula}: \code{term.list.formula} returns a list containing terms in a given
formula, handling \code{+} and \code{-} operators and parentheses, and
keeping track of whether a term has a plus or a minus sign.
}}

\examples{

## append.rhs.formula

(f1 <- append.rhs.formula(y~x,list(as.name("z1"),as.name("z2"))))
(f2 <- append.rhs.formula(~y,list(as.name("z"))))
(f3 <- append.rhs.formula(~y+x,list(as.name("z"))))
(f4 <- append.rhs.formula(~y,list(as.name("z")),TRUE))
(f5 <- append.rhs.formula(y~x,~z1+z2))

\dontshow{
stopifnot(f1 == (y~x+z1+z2))
stopifnot(f2 == (y~z))
stopifnot(f3 == (y+x~z))
stopifnot(f4 == (~y+z))
stopifnot(f5 == (y~x+z1+z2))
}

}
