% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{NVL}
\alias{NVL}
\alias{NVL2}
\alias{NVL3}
\alias{NVL<-}
\title{Convenience functions for handling \code{\link{NULL}} objects.}
\usage{
NVL(...)

NVL2(test, notnull, null = NULL)

NVL3(test, notnull, null = NULL)

NVL(x) <- value
}
\arguments{
\item{\dots, test}{expressions to be tested.}

\item{notnull}{expression to be returned if \code{test} is not \code{NULL}.}

\item{null}{expression to be returned if \code{test} is \code{NULL}.}

\item{x}{an object to be overwritten if \code{\link{NULL}}.}

\item{value}{new value for \code{x}.}
}
\description{
Convenience functions for handling \code{\link{NULL}} objects.
}
\section{Functions}{
\itemize{
\item \code{NVL}: Inspired by SQL function \code{NVL}, returns the first argument
that is not \code{NULL}, or \code{NULL} if all arguments are
\code{NULL}.

\item \code{NVL2}: Inspired by Oracle SQL function \code{NVL2}, returns the second argument
if the first argument is not \code{NULL} and the third argument if the
first argument is \code{NULL}. The third argument defaults to \code{NULL}, so
\code{NVL2(a, b)} can serve as shorthand for \code{(if(!is.null(a)) b)}.

\item \code{NVL3}: Inspired by Oracle SQL \code{NVL2} function and \code{magittr} \code{\%>\%}
operator, behaves as \code{NVL2} but \code{.}s in the second argument are
substituted with the first argument.

\item \code{NVL<-}: Assigning to \code{NVL} overwrites its first argument if that argument
is \code{\link{NULL}}. Note that it will \emph{always} return the right-hand-side
of the assignment (\code{value}), regardless of what \code{x} is.
}}

\note{
Whenever possible, these functions use lazy evaluation, so,
for example \code{NVL(1, stop("Error!"))} will never evaluate the
\code{\link{stop}} call and will not produce an error, whereas \code{NVL(NULL, stop("Error!"))} would.
}
\examples{
a <- NULL

a # NULL
NVL(a,0) # 0

b <- 1

b # 1
NVL(b,0) # 1

# Here, object x does not exist, but since b is not NULL, x is
# never evaluated, so the statement finishes.
NVL(b,x) # 1

# Also,
NVL(NULL,1,0) # 1
NVL(NULL,0,1) # 0
NVL(NULL,NULL,0) # 0
NVL(NULL,NULL,NULL) # NULL

NVL2(a, "not null!", "null!") # "null!"
NVL2(b, "not null!", "null!") # "not null!"

NVL3(a, "not null!", "null!") # "null!"
NVL3(b, .+1, "null!") # 2

NVL(a) <- 2
a # 2
NVL(b) <- 2
b # still 1
}
\seealso{
\code{\link{NULL}}, \code{\link[base]{is.null}}, \code{\link[base]{if}}
}
\keyword{utilities}
