% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.lc.stdmean.bs}
\alias{ci.lc.stdmean.bs}
\title{Confidence interval for a standardized linear contrast of means in a
between-subjects design}
\usage{
ci.lc.stdmean.bs(alpha, m, sd, n, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{vector of group sample means}

\item{sd}{vector of group sample standard deviation}

\item{n}{vector of sample sizes}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - bias adjusted standardized linear contrast
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for a population standardized linear contrast
of means in a between-subjects design. The square root weighted variance
standardizer is recommended in 2-group nonexperimental designs with simple
random sampling. The square root unweighted variance standardizer is
recommended in 2-group experimental designs. Equality of variances is not
assumed.
}
\examples{
m <- c(33.5, 37.9, 38.0, 44.1)
sd <- c(3.84, 3.84, 3.65, 4.98)
n <- c(10,10,10,10)
v <- c(.5, .5, -.5, -.5)
ci.lc.stdmean.bs(.05, m, sd, n, v)

# Should return:
#                           Estimate        SE        LL         UL
# Unweighted standardizer: -1.273964 0.3692800 -2.025039 -0.5774878
# Weighted standardizer:   -1.273964 0.3514511 -1.990095 -0.6124317


}
\references{
\insertRef{Bonett2008}{statpsych}
}
