% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.lc.glm}
\alias{ci.lc.glm}
\title{Confidence interval for a linear contrast of general linear model parameters}
\usage{
ci.lc.glm(alpha, n, b, V, q)
}
\arguments{
\item{alpha}{alpha for 1 - alpha confidence}

\item{n}{sample size}

\item{b}{vector of parameter estimates from coef(object)}

\item{V}{covariance matrix of parameter estimates from vcov(object)}

\item{q}{vector of coefficients}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of linear function
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a linear
contrast of parameters in a general linear model using coef(object) and
vcov(object) where "object" is a fitted model object from the lm function.
}
\examples{
y <- c(43, 62, 49, 60, 36, 79, 55, 42, 67, 50)
x1 <- c(3, 6, 4, 6, 2, 7, 4, 2, 7, 5)
x2 <- c(4, 6, 3, 7, 1, 9, 3, 3, 8, 4)
out <- lm(y ~ x1 + x2)
b <- coef(out)
V <- vcov(out)
n <- length(y)
q <- c(0, .5, .5)
b
ci.lc.glm(.05, n, b, V, q)

#  Should return:
# (Intercept)          x1          x2 
#   26.891111    3.648889    2.213333 
# > ci.lc.glm(.05, n, b, V, q)
#      Estimate        SE       t df           p       LL       UL
# [1,] 2.931111 0.4462518 6.56829  7 0.000313428 1.875893 3.986329


}
