% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.lc.stdmean.ws}
\alias{size.ci.lc.stdmean.ws}
\title{Sample size for a within-subjects standardized mean linear contrast
confidence interval}
\usage{
size.ci.lc.stdmean.ws(alpha, d, cor, w, q)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{d}{planning value of standardized linear contrast}

\item{cor}{planning value of average correlation between measurements}

\item{w}{desired confidence interval width}

\item{q}{vector of within-subjects contrast coefficients}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a standardized linear
contrast of population means with desired confidence interval precision
in a within-subjects design. Set the standardized mean difference planning
value to the largest value within a plausible range for a conservatively
large sample size. Set the pearson correlation planning value to the smallest
value within a plausible range for a conservatively large sample size.
}
\examples{
q <- c(.5, .5, -.5, -.5)
size.ci.lc.stdmean.ws(.05, 1, .7, .6, q)

# Should return:
#      Sample size
# [1,]          26
 

}
\references{
\insertRef{Bonett2009}{statpsych}
}
