% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.test.sign.ps}
\alias{size.test.sign.ps}
\title{Sample size for a paired-samples Sign test}
\usage{
size.test.sign.ps(alpha, pow, p)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{p}{planning value of proportion}
}
\value{
Returns the required sample size
}
\description{
Computes sample size required for a Sign test with desired power in a
paired-samples design. A planning value of the paired-samples Sign test
parameter is required. In a paired-samples experiment, this parameter
is the proportion of members in the population with scores that would be
larger under treatment 1 than treatment 2. In a paired-samples
nonexperiment, this parameter is the proportion of members in the
population with measurement 1 scores that are larger than their
measurement 2 scores.
}
\examples{
size.test.sign.ps(.05, .90, .75)

# Should return:
# Sample size
#          32
 

}
