% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{pi.var}
\alias{pi.var}
\title{Prediction limits for an estimated variance}
\usage{
pi.var(alpha, var, n0, n, type)
}
\arguments{
\item{alpha}{alpha value for upper 1-alpha confidence}

\item{var}{estimated variance from prior study}

\item{n0}{sample size used to estimate variance}

\item{n}{planned sample size of future study}

\item{type}{\itemize{
\item set to 1 for two-sided prediction interval
\item set to 2 for one-sided upper prediction limit
\item set to 3 for one-sided lower prediction limit
}}
}
\value{
Returns two-sided or one-sided prediction limits of an estimate variance
in a future study
}
\description{
Computes a two-sided or one-sided prediction limit for the estimated
variance in a future study for a planned sample size. The prediction limit
uses a variance estimate from a prior study.

Several confidence interval sample size functions in this package require
a planning value of the estimated variance that is expected in the planned
study. A one-sided upper variance prediction limit is useful as a variance
planning value for the sample size required to obtain a confidence interval
with desired width. This strategy for specifying a variance planning value
is useful in applications where the population variance in the prior study
is assumed to be very similar to the population variance in the planned
study.
}
\examples{
pi.var(.05, 15, 40, 100, 2)

# Should return:
#      UL
# 23.9724
 

}
\references{
\insertRef{Hahn1972}{statpsych}
}
