% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mot.R
\name{get_MOT}
\alias{get_MOT}
\title{Download vehicle data from the DVSA MOT API using VRM.}
\usage{
get_MOT(vrm, apikey)
}
\arguments{
\item{vrm}{A list of VRMs as character strings.}

\item{apikey}{Your API key as a character string.}
}
\description{
Download vehicle data from the DVSA MOT API using VRM.
}
\section{Details}{

This function takes a a character vector of vehicle registrations (VRMs) and returns vehicle data from MOT records.
It returns a data frame of those VRMs which were successfully used with the DVSA MOT API.

Information on the DVSA MOT API is available here:
https://dvsa.github.io/mot-history-api-documentation/

The DVSA MOT API requires a registration.  The function therefore requires the API key provided by the DVSA.
Be aware that the API has usage limits.  The function will therefore limit lists with more than 150,000 VRMs.
}

\examples{
\donttest{
vrm = c("1RAC","P1RAC")
apikey = Sys.getenv("MOTKEY")
if(nchar(apikey) > 0) {
  get_MOT(vrm = vrm, apikey = apikey)
}
}
}
