% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_anova_expressions.R
\name{expr_anova_robust}
\alias{expr_anova_robust}
\title{Expression containing results from heteroscedastic one-way ANOVA for
trimmed means}
\usage{
expr_anova_robust(
  data,
  x,
  y,
  paired = FALSE,
  tr = 0.1,
  nboot = 100,
  conf.level = 0.95,
  conf.type = "norm",
  k = 2,
  stat.title = NULL,
  messages = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Currently ignored.}
}
\value{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\description{
Expression containing results from heteroscedastic one-way ANOVA for
trimmed means
}
\examples{

\donttest{
# for reproducibility
set.seed(123)

# ------------------------ between-subjects -----------------------------

# going with the defaults
statsExpressions::expr_anova_robust(
  data = ggplot2::midwest,
  x = state,
  y = percbelowpoverty,
  paired = FALSE,
  nboot = 10
)

# changing defaults
expr_anova_robust(
  data = ggplot2::midwest,
  x = state,
  y = percollege,
  paired = FALSE,
  conf.level = 0.99,
  tr = 0.2,
  nboot = 10
)

# ------------------------ within-subjects -----------------------------

statsExpressions::expr_anova_robust(
  data = iris_long,
  x = condition,
  y = value,
  paired = TRUE,
  tr = 0.2,
  k = 3,
  nboot = 10
)
}
}
