% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_cond_eff.R
\name{print.cond_effect}
\alias{print.cond_effect}
\title{Print a 'cond_effect' Class Object}
\usage{
\method{print}{cond_effect}(
  x,
  nd = 3,
  nd_stat = 3,
  nd_p = 3,
  title = TRUE,
  model = TRUE,
  level_info = TRUE,
  standardized = TRUE,
  boot_info = TRUE,
  table_only = FALSE,
  ...
)
}
\arguments{
\item{x}{The output of \code{\link[=cond_effect]{cond_effect()}} or \code{\link[=cond_effect_boot]{cond_effect_boot()}}.}

\item{nd}{The number of digits for the variables.}

\item{nd_stat}{The number of digits for test statistics (e.g., \emph{t}).}

\item{nd_p}{The number of digits for \emph{p}-values.}

\item{title}{If \code{TRUE}, print a title. Default is \code{TRUE}.}

\item{model}{If \code{TRUE}, print the regression model. Default is \code{TRUE}.}

\item{level_info}{If \code{TRUE}, print information for interpreting the
levels of the moderator, such as the values of
the levels and distance from the mean. Default
is \code{TRUE}.}

\item{standardized}{If \code{TRUE} and one or more variables are
standardized, report it. Default is \code{TRUE}.`}

\item{boot_info}{If \code{TRUE} and bootstrap estimates are in \code{x},
print information about the bootstrapping,
such as the number of bootstrap samples.
Default is \code{TRUE}.}

\item{table_only}{If \code{TRUE}, will suppress of other elements except
for the table of conditional effects. Override
arguments such as \code{title}, \code{model}, and \code{level_info}.}

\item{...}{Additional arguments. Ignored by this function.}
}
\value{
\code{x} is returned invisibility.
}
\description{
Print the output of \code{\link[=cond_effect]{cond_effect()}} or \code{\link[=cond_effect_boot]{cond_effect_boot()}}.
}
\examples{

# Load a sample data set

dat <- test_x_1_w_1_v_1_cat1_n_500

# Do a moderated regression by lm
lm_raw <- lm(dv ~ iv*mod + v1 + cat1, dat)

cond_effect(lm_raw, x = iv, w = mod)

lm_std <- std_selected(lm_raw, to_scale = ~ iv + mod,
                               to_center = ~ iv + mod)

cond_effect(lm_std, x = iv, w = mod)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
