% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_modification-functions.R
\name{mortality}
\alias{mortality}
\title{Directly affect populations}
\usage{
mortality(mortality_layer, stages = NULL)
}
\arguments{
\item{mortality_layer}{the name of spatial layer(s) in the landscape object with
mortality proportions used to alter the populations for each timestep (number of
layers must match the intended timesteps)}

\item{stages}{which life-stages are modified - default is all}
}
\description{
This function modifies a population by a mortality spatial layer included in a
steps landscape object. The mortality layer consists of values from 0???1 and
modifies the population by multiplying the population of a cell by the value of
the corresponding cell in a mortality layer. For example, a cell with ten
individuals before the mortality function is applied, and corresponding mortality
layer cell with a value of 0.2, would have two individuals remaining after
modification. Note, rounding also occurs after modification using a ceiling method
(i.e the largest whole integer is retained).
}
\examples{
# Modify populations in all life-stages with fire intensity.

\dontrun{
fire_mortal <- mortality(mortality_layer = "fire", stages = NULL)

ls <- landscape(population = egk_pop,
                suitability = egk_hab,
                carrying_capacity = egk_k,
                "fire" = egk_fire)

pd <- population_dynamics(change = growth(egk_mat), modification = fire_mortal)

simulation(landscape = ls, population_dynamics = pd, habitat_dynamics = NULL, timesteps = 20)
}
}
