% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker_client.R
\name{docker_client}
\alias{docker_client}
\title{Create docker client}
\usage{
docker_client(..., api_version = NULL, host = NULL, cert_path = NULL,
  tls_verify = NULL, machine = NULL, http_client_type = NULL,
  data_frame = NULL, quiet = FALSE, debug = NULL,
  ignore_environment = FALSE)
}
\arguments{
\item{...}{Reserved for future use.  Passing in any unrecognised
argument will throw an error.  Part of the role of this argument
is to force use of named arguments until the API is stabilised.}

\item{api_version}{Version of the API to use when communicating
with the docker daemon.  The default value, \code{NULL}, detects
the docker server API version and attempts to match it (this
mirrors the default behaviour of the docker command line
client).  Alternatively, provide an API version number as a
string or \code{\link{numeric_version}} object (supported
between \Sexpr{stevedore:::DOCKER_API_VERSION_MIN} and
\Sexpr{stevedore:::DOCKER_API_VERSION_MAX}).  The version
\Sexpr{stevedore:::DOCKER_API_VERSION_DEFAULT} is the version
used in most automated tests, and if problems are encountered,
consider forcing this version).}

\item{host}{The URL for the docker daemon.  This can be a unix
socket (e.g., unix:///var/run/docker.sock) on macOS/Linux, a
named pipe (e.g., \code{npipe:////./pipe/docker_engine}) on
Windows, or an http or https url (e.g.,
\code{https://localhost:2376}).  If not given, we use the
environment variable \code{DOCKER_HOST}, falling back on the
default socket or named pipe (for macOS/unix and windows
respectively).}

\item{cert_path}{The path to a directory containing certificate
files.  If using an \code{https} url this is required.  If not
given, we use the environment variable \code{DOCKER_CERT_PATH}.
This is ignored without warning if used with a socket or named
pipe connection.}

\item{tls_verify}{Logical, indicating if TLS should be verified.
This is only used if using an https connection (i.e., host is a
tcp/http/https url and\code{cert_path} is given).  If not given,
we use the environment variable \code{DOCKER_TLS_VERIFY}.}

\item{machine}{Scalar character (if provided) indicating the name
of a "docker machine" instance to use.  If this is provided then
\code{docker-machine} must be installed and the machine must
exist and be running.  \code{stevedore} will run
\code{docker-machine env machine} to determine the environment
variables to contact this machine and use these values for
\code{host}, \code{cert_path} and \code{tls_verify} (silently
ignoring any provided values).  Carl Boettiger is working on a
\href{https://github.com/cboettig/dockermachine}{docker machine}
package for R that would make managing docker machines from R
easier.  As an alternative to this option, one can set
docker-machine environment variables as described in
\code{docker-machine env} before running R and they would be picked
up as described above.}

\item{http_client_type}{HTTP client type to use.  The options are
(currently) "curl", which uses the \code{curl} package (works
over unix sockets and over TCP) and \code{httppipe} which works
over unix sockets and windows named pipes, using the Docker
SDK's pipe code via the \code{httppipe} package.  Not all
functionality is supported with the \code{httppipe} client.
This option may eventually be moved into the \code{...} argument
as is not intended for end-user use; it is primarily intended
for debugging in development (forcing the \code{httppipe} client
where the \code{curl} client would ordinarily be preferred).}

\item{data_frame}{Function, used to wrap data.frames returned.
This may make output easier to consume.  You might use
\code{tibble::as_tibble} to return a \code{tbl_df} or
\code{datatable::as.data.table} to return \code{data.table}
objects.  This will be applied to all data.frames \emph{after}
they are constructed, and so must take a single argument (the
newly constructed data.frame) and return a new object that is
largely compatible with data.frame.  Another use for this would
be to define a function \code{data_frame = function(x)
structure(x, class = c("foo", "data.frame"))} to set the class
of all returned data.frame objects to be "foo" as well and then
defining a custom S3 print method for "foo" that limited the
output.}

\item{quiet}{Suppress informational messages.}

\item{debug}{Enable http debugging (supported by the curl http
driver only).  Provide a connection object and http headers and
content will be sent to it.  Using \code{debug = TRUE} is
equivalent to \code{code = stdout()}, while \code{debug = FALSE}
is equivalent to \code{debug = NULL} (the default) which
prevents debugging information being printed.  This option can
be used to write to a file by opening a writeable connection but
care must be made not to close this connection because otherwise
the curl requests may fail.}

\item{ignore_environment}{Logical, indicating if environment
variables (\code{DOCKER_HOST}, \code{DOCKER_CERT_PATH},
\code{DOCKER_TLS_VERIFY} and \code{DOCKER_API_VERSION}) should
be ignored (this has no effect if \code{machine} is specified).}
}
\description{
Create a docker client object, which allows you to interact with
docker from R.  The object has several \emph{methods} that allow
interaction with the docker daemon (for this object they are all
"system" commands) and \emph{collections}, which contains further
methods.  The client is structured similarly to the docker command
line client, such that \code{docker container create <args>} in
the command line becomes \code{docker$container$create(...)} in R
(if the client is called R).
}
\details{
\Sexpr[results=rd,stage=render]{stevedore:::generate_help()}
}
\section{Connection options}{


\code{stevedore} can connect to the docker daemon via a unix
socket (this is the default set-up on Linux and macOS), over a
named pipe (Windows 10 - see below) and https over a normal tcp
connection (this is especially useful with
\href{https://docs.docker.com/machine/}{\code{docker-machine}}.

\enumerate{

\item If the \code{machine} argument is given then
  \code{stevedore} queries \code{docker-machine} for settings.  If
  that command fails (e.g., there is no machine,
  \code{docker-machine} not installed) then that will cause an
  error.  (Note that the \code{docker-machine} output does not
  include API version information so the \code{api_version}
  argument is relevant, but \code{host}, \code{cert_path} and
  \code{tls_verify} will be silently ignored if provided).

\item The arguments \code{host} overrides the environment variable
  \code{DOCKER_HOST}, \code{cert_path} overrides
  \code{DOCKER_CERT_PATH} and \code{tls_verify} overrides
  \code{DOCKER_TLS_VERIFY}.  If \code{ignore_environment} is
  \code{TRUE} then the environment variables are not used at all.

\item if \code{code} is not provided by any of the above methods
  (machine, argument or environment variable) it will fall back
  on the default unix socket (\code{var/run/docker.sock}) on
  Linux/macOS or the default windows named pipe
  (\code{npipe:////./pipe/docker_engine}) on windows.

}

The API version is set by the \code{api_version} argument, which
falls back on the environment variable \code{DOCKER_API_VERSION}
(this is the same as the docker command line client and the python
SDK).  If neither are provided then \code{stevedore} will detect
the API version being used by the daemon and match that (provided
it falls within the range of versions supported by the package).
}

\examples{
if (stevedore::docker_available()) {
  # Create a new client object:
  client <- stevedore::docker_client()

  # Version information for your docker daemon:
  client$version()

  # General information about your daemon:
  client$info()

  # Most of the interesting methods are within the collections.
  # For example, to see a summary of running containers:
  client$container$list()

  # (see ?docker_container) for more information.
}
}
