% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csb_canceled.R
\name{csb_canceled}
\alias{csb_canceled}
\title{Remove Canceled Calls for Service}
\usage{
csb_canceled(.data, var, drop = TRUE)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{var}{Name of the column containing cancellation timestamps}

\item{drop}{A logical scalar; if \code{TRUE}, removes the now empty column
that had contained cancellation date and time, otherwise if \code{FALSE}
the empty column is retained.}
}
\value{
Returns a tibble with the rows containing dates and times for the
    given variable removed.
}
\description{
Subsets data to remove any call with a date and time canceled.
}
\examples{
csb_canceled(january_2018, var = "datecancelled")
csb_canceled(january_2018, var = "datecancelled", drop = FALSE)

}
