% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Johnston_Flight_heights_SOSS}
\alias{Johnston_Flight_heights_SOSS}
\title{Summarized flight height profiles from Johnston et al (2014)}
\format{
A data frame object with 3 columns containing the maximum likelihood,
the median, and Upper/Lower confidence limits of flight height distributions.
Flight height bands go from 1 - 300m ASL.

\describe{
\item{height}{Height above sea level, in metres. First element represents the
0-1 meters height band, and height interval is 1 metre.}
\item{variable}{The species name and variable from Johnston et al 2014 estimates.
E.G., ArcticSkua.est is the maximum likelihood estimate from  those models.
.est = maximum likelihood, .lcl and .ucl are the lower and upper 95\% CLs, and
.med is the median estimate.}
\item{prop}{The proportion of birds within the 1m flight height bands.}
}
}
\source{
\url{https://www.bto.org/our-science/wetland-and-marine/soss/projects}
}
\usage{
Johnston_Flight_heights_SOSS
}
\description{
A dataframe containing flight height profiles for all species in Johnston
et al. (2014). Values are expressed as the proportion
of birds in 1 metre height intervals.
}
\keyword{datasets}
