% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{chord_prof_5MW}
\alias{chord_prof_5MW}
\title{Rotor blade chord profile}
\format{
A dataframe
\describe{
\item{pp_radius}{radius at bird passage point, as a proportion of rotor radius (R)}
\item{chord}{chord width at pp_radius, as a proportion of the maximum chord width}
...
}
}
\usage{
chord_prof_5MW
}
\description{
A data.frame giving the blade's chord width profile, i.e. the chord width
along the length of the blade, provided as a proportion of its maximum width.
}
\details{
This is a generic profile for a typical modern 5MW turbine used for offshore generation.
Due to commercial sensitivities by blade manufacturers, some of this detailed
information may not be readily available for each make/model of blade and
hence generic information may have to be used.
}
\note{
\code{"chord_prof_5MW"} is numerically identical to \code{"coverC"}.
\code{"coverC"} should become deprecated in future versions of the code
}
\keyword{datasets}
