% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtnorm_dmp.R
\name{rtnorm_dmp}
\alias{rtnorm_dmp}
\title{Customised sampling of Truncated Normal distribution}
\usage{
rtnorm_dmp(n, mean = 0, sd = 1, lower = -Inf, upper = Inf)
}
\arguments{
\item{n}{An integer value. The number of samples to generate}

\item{mean}{A decimal value. The mean for the truncated normal distribution}

\item{sd}{A decimal value. The standard deviation of the distribution to simulate}

\item{lower}{A decimal value. The lower limit for the distribution}

\item{upper}{A decimal value. The upper limit for the distribution}
}
\value{
a vector of samples values from the truncated normal distribution
}
\description{
Wrapper of the msm::rtnorm() function, improving on outputs management and
user feedback on edge cases
}
\examples{
rtnorm_dmp(n=10,mean=0.4,sd=0.2)


}
