% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers_free.R
\name{run_oLBFGS_free}
\alias{run_oLBFGS_free}
\title{Run oLBFGS optimizer in free-mode}
\usage{
run_oLBFGS_free(optimizer, x, step_size)
}
\arguments{
\item{optimizer}{An `oLBFGS_free` optimizer, for which its last request must have been served. Will be updated in-place.}

\item{x}{Current values of the variables being optimized. Must be a numeric vector. Will be updated in-place.}

\item{step_size}{Step size for the quasi-Newton update.}
}
\value{
A request with the next piece of required information. The output will be a list with the following levels:
\itemize{
   \item{task} Requested task (one of "calc_grad" or "calc_grad_same_batch").
   \item{requested_on} Values of `x` at which the requested information must be calculated.
   \item{info} \itemize{
      \item{x_changed_in_run} Whether the `x` vector was updated.
      \item{iteration_number} Current iteration number (in terms of quasi-Newton updates).
      \item{iteration_info} Information about potential problems encountered during the iteration.
   } 
}
}
\description{
Run the next step of an oLBFGS optimization procedure, after the last requested calculation
has been fed to the optimizer. When run for the first time, there is no request, so the function just
needs to be run on the object as it is returned from function `oLBFGS_free`.
}
\seealso{
\link{oLBFGS_free}
}
