% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{svsample2}
\alias{svsample2}
\title{Minimal overhead version of \code{\link{svsample}}.}
\usage{
svsample2(y, draws = 1, burnin = 0, priormu = c(0, 100),
  priorphi = c(5, 1.5), priorsigma = 1, priornu = NA,
  priorlatent0 = "stationary", thinpara = 1, thinlatent = 1,
  thintime = 1, keeptau = FALSE, quiet = TRUE, startpara,
  startlatent)
}
\arguments{
\item{y}{numeric vector containing the data (usually log-returns), which
must not contain zeroes.}

\item{draws}{single number greater or equal to 1, indicating the number of
draws after burn-in (see below). Will be automatically coerced to integer.
The defaults value is 1.}

\item{burnin}{single number greater or equal to 0, indicating the number of
draws discarded as burn-in. Will be automatically coerced to integer. The
default value is 0.}

\item{priormu}{numeric vector of length 2, indicating mean and standard
deviation for the Gaussian prior distribution of the parameter \code{mu},
the level of the log-volatility. The default value is \code{c(0, 100)},
which constitutes a practically uninformative prior for common exchange rate
datasets, stock returns and the like.}

\item{priorphi}{numeric vector of length 2, indicating the shape parameters
for the Beta prior distribution of the transformed parameter
\code{(phi + 1) / 2}, where \code{phi} denotes the persistence of the
log-volatility. The default value is \code{c(5, 1.5)}, which constitutes a
prior that puts some belief in a persistent log-volatility but also
encompasses the region where \code{phi} is around 0.}

\item{priorsigma}{single positive real number, which stands for the scaling
of the transformed parameter \code{sigma^2}, where \code{sigma} denotes the
volatility of log-volatility. More precisely, \code{sigma^2 ~ priorsigma *
chisq(df = 1)}. The default value is \code{1}, which constitutes a
reasonably vague prior for many common exchange rate datasets, stock returns
and the like.}

\item{priornu}{numeric vector of length 2 (or \code{NA}), indicating the
lower and upper bounds for the uniform prior distribution of the parameter
\code{nu}, the degrees-of-freedom parameter of the conditional innovations
t-distribution. The default value is \code{NA}, fixing the
degrees-of-freedom to infinity. This corresponds to conditional standard
normal innovations, the pre-1.1.0 behavior of \pkg{stochvol}.}

\item{priorlatent0}{either a single non-negative number or the string
\code{'stationary'} (the default, also the behavior before version 1.3.0).
When \code{priorlatent0} is equal to \code{'stationary'}, the stationary
distribution of the latent AR(1)-process is used as the prior for the
initial log-volatility \code{h_0}. When \code{priorlatent0} is equal to a
number \eqn{B}, we have \eqn{h_0 \sim N(\mu, B\sigma^2)} a priori.}

\item{thinpara}{single number greater or equal to 1, coercible to integer.
Every \code{thinpara}th parameter draw is kept and returned. The default
value is 1, corresponding to no thinning of the parameter draws -- every
draw is stored.}

\item{thinlatent}{single number greater or equal to 1, coercible to integer.
Every \code{thinlatent}th latent variable draw is kept and returned. The
default value is 1, corresponding to no thinning of the latent variable
draws, i.e. every draw is kept.}

\item{thintime}{single number greater or equal to 1, coercible to integer.
If \code{thintime} is different from 1, only every \code{thintime}th latent
log-volatility is being monitored. If, e.g., \code{thintime = 3}, the latent
log-volatilities \code{h_1,h_4,h_7,...} will be kept. The default value is
1, meaning that all latent variables \code{h_1,h_2,h_3,...} are stored.}

\item{keeptau}{logical value indicating whether the 'variance inflation
factors' should be stored (used for the sampler with conditional t
innovations only). This may be useful to check at what point(s) in time the
normal disturbance had to be 'upscaled' by a mixture factor and when the
series behaved 'normally'.}

\item{quiet}{logical value indicating whether the progress bar and other
informative output during sampling should be omitted. The default value is
\code{TRUE}, implying non-verbose output.}

\item{startpara}{\emph{compulsory} named list, containing the starting
values for the parameter draws. \code{startpara} must contain three elements
named \code{mu}, \code{phi}, and \code{sigma}, where \code{mu} is an
arbitrary numerical value, \code{phi} is a real number between \code{-1} and
\code{1}, and \code{sigma} is a positive real number. Moreover, if
\code{priornu} is not \code{NA}, \code{startpara} must also contain an
element named \code{nu} (the degrees of freedom parameter for the
t-innovations).}

\item{startlatent}{\emph{compulsory} vector of length \code{length(x$y)},
containing the starting values for the latent log-volatility draws.}
}
\value{
A list with three components:
\item{para}{\code{3} times
\code{draws} matrix containing the parameter draws. If \code{priornu} is not
\code{NA}, this is a \code{4} times \code{draws} matrix.}
\item{latent}{\code{length(y)} times \code{draws} matrix containing draws of
the latent variables \code{h_1, \dots{}, h_n}.}
\item{latent0}{Vector of
length \code{draws} containing the draw(s) of the initial latent variable
\code{h_0}.}
}
\description{
\code{svsample2} is a minimal overhead version of \code{\link{svsample}}
with slightly different default arguments and a simplified return value
structure. It is intended to be used mainly for one-step updates where speed
is an issue, e.g., as a plug-in into other MCMC samplers. Note that
absolutely no input checking is performed, thus this function is to be used
with proper care!
}
\details{
As opposed to the ordinary \code{\link{svsample}}, the default values differ
for \code{draws}, \code{burnin}, and \code{quiet}. Note that currently
neither \code{expert} nor \code{\dots{}} arguments are provided.
}
\note{
Please refer to the package vignette for an example.
}
\section{Warning}{
 Expert use only! For most applications, the use of
\code{\link{svsample}} is recommended.
}

\examples{
data(exrates)
aud.price <- subset(exrates,
  as.Date("2010-01-01") <= date & date < as.Date("2011-01-01"),
  "AUD")[,1]
draws <- svsample2(logret(aud.price),
                   draws = 10, burnin = 0,
                   startpara = list(phi = 0.95, mu = -10, sigma = 0.2, rho = -0.1),
                   startlatent = rep_len(-10, length(aud.price) - 1))
}
\seealso{
\code{\link{svsample}}
}
\author{
Gregor Kastner \email{gregor.kastner@wu.ac.at}
}
\keyword{models}
\keyword{ts}
