% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{svsample_roll}
\alias{svsample_roll}
\alias{svtsample_roll}
\alias{svlsample_roll}
\alias{svtlsample_roll}
\title{Rolling Estimation of Stochastic Volatility Models}
\usage{
svsample_roll(
  y,
  designmatrix = NA,
  n_ahead = 1,
  forecast_length = 500,
  n_start = NULL,
  refit_every = 1,
  refit_window = c("moving", "expanding"),
  calculate_quantile = c(0.01),
  calculate_predictive_likelihood = TRUE,
  keep_draws = FALSE,
  parallel = c("no", "multicore", "snow"),
  n_cpus = 1L,
  cl = NULL,
  ...
)

svtsample_roll(
  y,
  designmatrix = NA,
  n_ahead = 1,
  forecast_length = 500,
  n_start = NULL,
  refit_every = 1,
  refit_window = c("moving", "expanding"),
  calculate_quantile = c(0.01),
  calculate_predictive_likelihood = TRUE,
  keep_draws = FALSE,
  parallel = c("no", "multicore", "snow"),
  n_cpus = 1L,
  cl = NULL,
  ...
)

svlsample_roll(
  y,
  designmatrix = NA,
  n_ahead = 1,
  forecast_length = 500,
  n_start = NULL,
  refit_every = 1,
  refit_window = c("moving", "expanding"),
  calculate_quantile = c(0.01),
  calculate_predictive_likelihood = TRUE,
  keep_draws = FALSE,
  parallel = c("no", "multicore", "snow"),
  n_cpus = 1L,
  cl = NULL,
  ...
)

svtlsample_roll(
  y,
  designmatrix = NA,
  n_ahead = 1,
  forecast_length = 500,
  n_start = NULL,
  refit_every = 1,
  refit_window = c("moving", "expanding"),
  calculate_quantile = c(0.01),
  calculate_predictive_likelihood = TRUE,
  keep_draws = FALSE,
  parallel = c("no", "multicore", "snow"),
  n_cpus = 1L,
  cl = NULL,
  ...
)
}
\arguments{
\item{y}{numeric vector containing the data (usually log-returns), which
must not contain zeros. Alternatively, \code{y} can be an \code{svsim}
object. In this case, the returns will be extracted and a message is signalled.}

\item{designmatrix}{regression design matrix for modeling the mean. Must
have \code{length(y)} rows. Alternatively, \code{designmatrix} may be a
string of the form \code{"arX"}, where \code{X} is a nonnegative integer. To
fit a constant mean model, use \code{designmatrix = "ar0"} (which is
equivalent to \code{designmatrix = matrix(1, nrow = length(y))}). To fit an
AR(1) model, use \code{designmatrix = "ar1"}, and so on. If some elements of
\code{designmatrix} are \code{NA}, the mean is fixed to zero (pre-1.2.0
behavior of \pkg{stochvol}).}

\item{n_ahead}{number of time steps to predict from each time window.}

\item{forecast_length}{the time horizon at the end of the data set
that is used for backtesting.}

\item{n_start}{\emph{optional} the starting time point for backtesting.
Computed from \code{forecast_length} if omitted.}

\item{refit_every}{the SV model is refit every \code{refit_every} time steps.
Only the value \code{1} is allowed.}

\item{refit_window}{one of \code{"moving"} or \code{"expanding"}. If
\code{"expanding"}, then the start of the time window stays
at the beginning of the data set. If \code{"moving"}, then the
length of the time window is constant throughout backtesting.}

\item{calculate_quantile}{vector of numbers between 0 and 1.
These quantiles are predicted using \code{\link{predict.svdraws}}
for each time window.}

\item{calculate_predictive_likelihood}{boolean. If \code{TRUE},
the \code{n_ahead} predictive density is evaluated at the 
\code{n_ahead} time observation after each time window.}

\item{keep_draws}{boolean. If \code{TRUE}, the \code{svdraws} and
the \code{svpredict} objects are kept from each time window.}

\item{parallel}{one of \code{"no"} (default), \code{"multicore"}, or \code{"snow"},
indicating what type of parallellism is to be applied. Option
\code{"multicore"} is not available on Windows.}

\item{n_cpus}{\emph{optional} positive integer, the number of CPUs to be used in case of
parallel computations. Defaults to \code{1L}. Ignored if parameter
\code{cl} is supplied and \code{parallel != "snow"}.}

\item{cl}{\emph{optional} so-called SNOW cluster object as implemented in package
\code{parallel}. Ignored unless \code{parallel == "snow"}.}

\item{\dots}{Any extra arguments will be forwarded to
\code{\link{svsample}}, controlling the prior setup, the starting values for the
MCMC chains, the number of independent MCMC chains, thinning and other expert
settings.}
}
\value{
The value returned is a list object of class \code{svdraws_roll}
holding a list item for every time window. The elements of these list items are
\item{indices}{a list object containing two elements: \code{train} is the vector
of indices used for fitting the model, and \code{test} is the vector of indices
used for prediction. The latter is mainly useful if a \code{designmatrix} is provided.}
\item{quantiles}{the input parameter \code{calculate_quantiles}.}
\item{refit_every}{the input parameter \code{refit_every}.}
\item{predictive_likelihood}{present only if \code{calculate_predictive_likelihood}
is \code{TRUE}. Then it is a number, the expected predictive density
of the observation. The expecation is taken over the joint \code{n_ahead} predictive
distribution of all model parameters.}
\item{predictive_quantile}{present only if \code{calculate_quantile} is a non-empty
vector. Then it is a vector of quantiles from the \code{n_ahead} predictive
distribution of \code{y}. It is based on MCMC simulation by using \code{\link{predict}}.}
\item{fit}{present only if \code{keep_draws} is \code{TRUE}. Then it is an
\code{svdraws} object as returned by \code{\link{svsample}}.}
\item{prediction}{present only if \code{keep_draws} is \code{TRUE}. Then it is an
\code{svpredict} object as returned by \code{\link{predict.svdraws}}.}

To display the output, use \code{print} and \code{summary}. The
\code{print} method simply prints a short summary of the setup;
the \code{summary} method displays the summary statistics
of the backtesting.
}
\description{
\code{svsample_roll} performs rolling window estimation based on \link{svsample}.
A convenience function for backtesting purposes.
}
\details{
Functions \code{svtsample_roll}, \code{svlsample_roll}, and \code{svtlsample_roll} are
wrappers around \code{svsample_roll} with convenient default values for the SV
model with t-errors, leverage, and both t-errors and leverage, respectively.
}
\note{
The function executes \code{\link{svsample}} \code{(length(y) - arorder - n_ahead - n_start + 2) \%/\% refit_every} times.
}
\examples{
\donttest{
# Simulate from the true model
sim <- svsim(200)

# Perform rolling estimation using the vanilla SV
# model and default priors
roll <- svsample_roll(sim, draws = 5000, burnin = 2000,
                      keep_draws = TRUE,
                      forecast_length = 10,
                      n_ahead = 1, refit_every = 1,
                      refit_window = "moving",
                      calculate_predictive_likelihood = TRUE,
                      calculate_quantile = c(0.01, 0.05))

# Perform rolling estimation by making use
# of two CPU cores, advanced priors, and multiple
# chains with pre-set initial values. Let us combine
# that with an AR(2) specification
prior_beta <- sv_multinormal(c(1,0,-1), rbind(c(1, 0, 0.1),
                                              c(0, 0.3, -0.04),
                                              c(0.1, -0.04, 0.1)))
priorspec <- specify_priors(rho = sv_beta(4, 4),
                            latent0_variance = sv_constant(1),
                            beta = prior_beta,
                            nu = sv_exponential(0.05))
startpara <- list(list(mu = -9, phi = 0.3),
                  list(mu = -11, sigma = 0.1, phi = 0.95),
                  list(phi = 0.99))
roll <- svsample_roll(sim, draws = 5000, burnin = 2000,
                      designmatrix = "ar2",
                      priorspec = priorspec,
                      startpara = startpara,
                      parallel = "snow", n_cpus = 2,
                      n_chains = 3,
                      keep_draws = TRUE,
                      forecast_length = 10,
                      n_ahead = 1, refit_every = 1,
                      refit_window = "expanding",
                      calculate_predictive_likelihood = TRUE,
                      calculate_quantile = c(0.01, 0.05))
}
}
\seealso{
\code{\link{svsim}}, \code{\link{specify_priors}}, \code{\link{svsample}}
}
\keyword{backtesting}
\keyword{estimation}
\keyword{models}
\keyword{rolling}
\keyword{ts}
\keyword{window}
