% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rule.R
\name{print.rule}
\alias{print.rule}
\title{Print Stopping Rule}
\usage{
\method{print}{rule}(x, ...)
}
\arguments{
\item{x}{A rule object, containing a matrix describing a stopping rule}

\item{...}{Other options to be passed to generic \code{plot} function}
}
\value{
A matrix with two columns: the sample sizes at which sequential testing is performed, and their corresponding rejection boundaries
}
\description{
Display a stopping rule in tabular form
}
\examples{
# Binomial Pocock test in 50 patient cohort at 10\% level, expected toxicity rate of 20\%
poc_rule = calc.rule(ns=1:50,p0=0.20,type="Pocock",alpha=0.10)

# Print stopping rule in table
print(poc_rule)
}
