% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdryfcn.surv.R
\name{bdryfcn.surv}
\alias{bdryfcn.surv}
\title{Stopping Rule Boundary Function (Survival Data)}
\usage{
bdryfcn.surv(n, p0, type, tau, cval, param = NULL)
}
\arguments{
\item{n}{Maximum sample size for safety monitoring}

\item{p0}{The probability of a toxicity occurring in \code{tau} units of time under the null hypothesis}

\item{type}{The method used for constructing the stopping rule. Choices including a Pocock test ("Pocock"),
a O'Brein-Fleming test ("OBF"), a Wang-Tsiatis test ("WT"), the Bayesian Gamma-Poisson method ("Bayesian"),
a modified sequential probability ratio test ("SPRT"), and a maximized SPRT ("MaxSPRT")}

\item{tau}{Observation period}

\item{cval}{Critical for the stopping rule. For Wang-Tsiatis tests, this is the Delta parameter. For the Bayesian Gamma-Poisson method, this is the threshold on the posterior probability. For the truncated SPRT, this is the threshold on the log likelihood ratio. For the MaxSPRT, this is the threshold on the log generalized likelihood ratio.}

\item{param}{Extra parameter(s) needed for certain stopping rule methods. For Wang-Tsiatis tests, this is the Delta parameter. For modified SPRT, this is the targeted alternative toxicity probability p1. For Bayesian Gamma-Poisson model, this is the pair of hyperparameters for the gamma prior on the toxicity event rate.}
}
\value{
A univariate function that defines the rejection boundary at any number of evaluable patients
}
\description{
Calculate the boundary for a given stopping rule
}
