% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.rule.surv.R
\name{calc.rule.surv}
\alias{calc.rule.surv}
\title{Stopping Rule Calculation (Survival Data)}
\usage{
calc.rule.surv(n, p0, alpha, type, tau, param = NULL)
}
\arguments{
\item{n}{Maximum sample size for safety monitoring}

\item{p0}{The probability of a toxicity occurring in \code{tau}] units of time under the null hypothesis}

\item{alpha}{The desired type I error/false positive rate for the stopping rule}

\item{type}{The method used for constructing the stopping rule. Choices including a Pocock test ("Pocock"),
a O'Brein-Fleming test ("OBF"), a Wang-Tsiatis test ("WT"), the Bayesian Gamma-Poisson method ("Bayesian"),
a modified sequential probability ratio test ("SPRT"), and a maximized SPRT ("MaxSPRT")}

\item{tau}{Observation period}

\item{param}{Extra parameter(s) needed for certain stopping rule methods. For Wang-Tsiatis tests, this is the Delta parameter. For modified SPRT, this is the targeted alternative toxicity probability p1. For Bayesian Gamma-Poisson model, this is the pair of hyperparameters for the gamma prior on the toxicity event rate.}
}
\value{
A rule.surv object, which is a list with the following elements: Rule, a two-column matrix with total follow-up times for each stage and their corresponding rejection boundaries; n; p0; alpha; type; tau; param; and cval
}
\description{
Calculate a stopping rule for safety monitoring for time-to-event data
}
\examples{
calc.rule.surv(n = 30, p0 = 0.1, alpha = 0.05, type = "Pocock", tau = 100)
}
\references{
Kulldorff, M., Davis, R. L., Kolczak, M., Lewis, E., Lieu, T., and Platt, R. (2011). A maximized sequential probability ratio test for drug and vaccine safety surveillance. \emph{Sequential Analysis}, \strong{30(1)}, 58–78.

Zacks, S. and Mukhopadhyay, N. (2006). Exact risks of sequential point estimators of the exponential parameter. \emph{Sequential Analysis}, \strong{25(2)}, 203–226.
}
