% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findconst.surv.R
\name{findconst.surv}
\alias{findconst.surv}
\title{Search for Calibration Value (Survival Data)}
\usage{
findconst.surv(n, p0, alpha, type, tau, param = NULL)
}
\arguments{
\item{n}{Maximum sample size for safety monitoring}

\item{p0}{The probability of a toxicity occurring in \code{tau}] units of time under the null hypothesis}

\item{alpha}{The desired type I error/false positive rate for the stopping rule}

\item{type}{The method used for constructing the stopping rule}

\item{tau}{Observation period}

\item{param}{Extra parameter(s) needed for certain stopping rule methods. For Wang-Tsiatis tests, this is the Delta parameter. For modified SPRT, this is the targeted alternative toxicity probability p1. For Bayesian Gamma-Poisson model, this is the pair of hyperparameters for the gamma prior on the toxicity event rate.}
}
\value{
The calibration constant used for subsequent stopping boundary calculation
}
\description{
Internal workhorse function to calculate the calibration constant value that attains level alpha for given method for time-to-event data
}
