% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_powermds.R
\name{stop_powermds}
\alias{stop_powermds}
\title{STOPS version of powermds}
\usage{
stop_powermds(
  dis,
  theta = c(1, 1),
  type = "ratio",
  weightmat = 1 - diag(nrow(dis)),
  init = NULL,
  ndim = 2,
  itmaxi = 10000,
  ...,
  stressweight = 1,
  structures = c("cclusteredness", "clinearity", "cdependence", "cmanifoldness",
    "cassociation", "cnonmonotonicity", "cfunctionality", "ccomplexity", "cfaithfulness",
    "cregularity", "chierarchy", "cconvexity", "cstriatedness", "coutlying",
    "cskinniness", "csparsity", "cstringiness", "cclumpiness", "cinequality"),
  strucweight = rep(1/length(structures), length(structures)),
  strucpars,
  verbose = 0,
  stoptype = c("additive", "multiplicative"),
  registry = struc_reg
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector of powers; a vector of length 2 where the first element is kappa (for the fitted distances), the second lambda (for the observed proximities). If a scalar is given it is recycled.  Defaults to 1,1.}

\item{type}{MDS type. Defaults to "ratio".}

\item{weightmat}{(optional) a matrix of nonnegative weights}

\item{init}{(optional) initial configuration}

\item{ndim}{number of dimensions of the target space}

\item{itmaxi}{number of iterations}

\item{...}{additional arguments to be passed to the fitting procedure}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{structures}{which structures to look for}

\item{strucweight}{weight to be used for the structures; defaults to 0.5}

\item{strucpars}{a list of parameters for the structuredness indices; each list element corresponds to one index in the order of the appeacrance in structures}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{stoptype}{which weighting to be used in the multi-objective optimization? Either 'additive' (default) or 'multiplicative'.}

\item{registry}{registry object with c-structuredness indices.}
}
\value{
A list with the components
\itemize{
        \item stress: the stress-1 value
        \item stress.m: default normalized stress
        \item stoploss: the weighted loss value
        \item struc: the structuredness indices
        \item parameters: the parameters used for fitting (kappa, lambda)
        \item fit: the returned object of the fitting procedure
        \item{stopobj:} the stopobj object 
}
}
\description{
This is power stress with free kappa and lambda but rho is fixed to 1, so no weight transformation.
}
\keyword{multivariate}
