% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver_external.R
\name{storr_external}
\alias{storr_external}
\title{Storr that kooks for external resources}
\usage{
storr_external(storage_driver, fetch_hook, default_namespace = "objects")
}
\arguments{
\item{storage_driver}{Another \code{storr} driver to handle the
actual storage.}

\item{fetch_hook}{A function to run to fetch data when a key is
not found in the store.  This function must take arguments
\code{key} and \code{namespace} and return an R object.  It must
throw an error if the external resource cannot be resolved.}

\item{default_namespace}{Default namespace (see
\code{\link{storr}})}
}
\description{
storr for fetching external resources.  This driver is used where
will try to fetch from an external data source if a resource can
not be found locally.  This works by checking to see if a key is
present in the storr (and if so returning it).  If it is not
found, then the function \code{fetch_hook} is run to fetch it.
}
\details{
See the vignette \code{vignette("external")} for much more detail.
This function is likely most useful for things like caching
resources from websites, or computing long-running quantities on
demand.
}
