% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo-functions.R
\name{mapshape}
\alias{mapshape}
\title{Simplify geometry of spatial objects with the mapshaper library}
\usage{
mapshape(shp, percent = 10, ms_options = "", dsn = "mapshape",
  silent = FALSE)
}
\arguments{
\item{shp}{A spatial object to be simplified.}

\item{percent}{A number between 1 and 100 stating how aggressively to simplify
the object (1 is a very aggressive simplification)}

\item{ms_options}{Text string of options passed to mapshaper such as}

\item{dsn}{The name of the temporary file to write to (deleted after use)}

\item{silent}{Logical determining whether the function call is printed to screen
\code{no-topology} (a flag) and \code{snap-interval=1} (a key value pair).
See the mapshaper documentation for details:
\url{https://github.com/mbloch/mapshaper/wiki/Command-Reference}.

The percent argument refers to the percentage of removable points to retain.
So \code{percent = 1} is a very aggressive simplication, saving a huge amount of
hard-disk space.}
}
\description{
Simplify geometry of spatial objects with the mapshaper library
}
\section{Details}{


Note: more advance R/mapshaper tools are provided by the rmapshaper
package: \url{https://github.com/ateucher/rmapshaper}.

Calls the JavaScript command-line GIS application mapshaper
(\url{https://github.com/mbloch/mapshaper}) from the system
to simplify geographic features, and then tidies up.
mapshaper must be installed and available to \code{\link{system}}.
\code{mapshape} writes new a file to disk.
Thanks to Richard and Adrian Ellison for demonstrating this in R.
}
\examples{
\dontrun{
data(routes_fast)
shp <- routes_fast[1,]
rfs10 <- mapshape(shp)
rfs5 <- mapshape(shp, percent = 5)
rfs1 <- mapshape(shp, percent = 1)
plot(shp)
plot(rfs10, add = TRUE, col ="red")
plot(rfs5, add = TRUE, col ="blue")
plot(rfs1, add = TRUE, col = "grey")
# snap the lines to the nearest interval
rfs_int <- mapshape(shp, ms_options = "snap-interval=0.001")
plot(shp)
plot(rfs_int, add = TRUE)
}
}
\seealso{
\code{\link[rgeos]{gSimplify}}
}

