% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{line2route}
\alias{line2route}
\title{Convert straight SpatialLinesDataFrame from flow data into routes}
\usage{
line2route(l, route_fun = "route_cyclestreet", n_print = 10,
  list_output = FALSE, l_id = NA, n_processes = 1, ...)
}
\arguments{
\item{l}{A SpatialLinesDataFrame}

\item{route_fun}{A routing function to be used for converting the straight lines to routes
\code{\link{od2line}}}

\item{n_print}{A number specifying how frequently progress updates
should be shown}

\item{list_output}{If FALSE (default) assumes SpatialLinesDataFrame output. Set to TRUE to save output as a list.}

\item{l_id}{Character string naming the id field from the input lines data,
typically the origin and destination ids pasted together. If absent, the row name of the
straight lines will be used.}

\item{n_processes}{The number of processes the routing requests should be made from, default 1.}

\item{...}{Arguments passed to the routing function, e.g. \code{\link{route_cyclestreet}}}
}
\description{
Convert straight SpatialLinesDataFrame from flow data into routes
}
\section{Details}{


See \code{\link{route_cyclestreet}} and other route functions for details
}

\examples{
\dontrun{
l = flowlines[2,]
line2route(l)
l = flowlines[2:5,]
rf <- line2route(l = l, "route_cyclestreet", plan = "fastest")
rq <- line2route(l = l, plan = "quietest", silent = TRUE)
plot(rf, col = "red")
plot(rq, col = "green", add = TRUE)
plot(l, add = T)
# Plot for a single line to compare 'fastest' and 'quietest' route
n = 2
plot(l[n,])
lines(rf[n,], col = "red")
lines(rq[n,], col = "green")
# Example with list output
l <- l[1:3,]
rf_list <- line2route(l = l, list_output = TRUE)
class(rf_list)       # list output
class(rf_list[[2]])  # but individual elements are spatial
rf_list_of_lists <- line2route(l = l, list_output = TRUE, save_raw = TRUE)
class(rf_list_of_lists)       # list output
class(rf_list_of_lists[[2]])  # but individual elements are spatial
# illustration of how the l_id argument works:
rf$id # has id as l has "id" field
l$id <- NULL # remove id field for testing
rf_no_id <- line2route(l)
rf_no_id$id # [1] "1" "2" "3" "4"
rf_with_id = line2route(l, l_id = "All")
rf_with_id$id # [1] 38 10 44
rf_with_err = line2route(l,  reporterrors = T)
# rf_with_err$error[2] has the correct error message
}
}
