% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od_coords.R
\name{od_coords}
\alias{od_coords}
\title{General function to create a matrix representing origins and destinations}
\usage{
od_coords(from = NULL, to = NULL, l = NULL)
}
\arguments{
\item{from}{An object representing origins
(if lines are provided as the first argument, from is assigned to \code{l})}

\item{to}{An object representing destinations}

\item{l}{Only needed if from and to are empty, in which case this
should be a spatial object representing desire lines}
}
\description{
This function takes a wide range of input data types (spatial lines, points or text strings)
and returns a matrix of coordinates representing origin (fx, fy) and destination (tx, ty) points.
}
\examples{
od_coords(from = cents[1:3, ], to = cents[2:4, ]) # Spatial points
od_coords(cents_sf[1:3, ], cents_sf[2:4, ]) # sf points
# od_coords("Hereford", "Leeds") # geocode locations
od_coords(flowlines)
od_coords(flowlines_sf)
}
