% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{line_bearing}
\alias{line_bearing}
\title{Find the bearing of straight lines}
\usage{
line_bearing(l, bidirectional = FALSE)
}
\arguments{
\item{l}{A spatial lines object}

\item{bidirectional}{Should the result be returned in a bidirectional format?
Default is FALSE. If TRUE, the same line in the oposite direction would have the same bearing}
}
\description{
This is a simple wrapper around the geosphere function \code{\link[=bearing]{bearing()}} to return the
bearing (in degrees relative to north) of lines.
}
\details{
Returns a boolean vector. TRUE means that the associated line is in fact a point
(has no distance). This can be useful for removing data that will not be plotted.
}
\examples{
lib_versions <- sf::sf_extSoftVersion()
lib_versions
# fails on some systems (with early versions of PROJ)
if (lib_versions[3] >= "6.3.1") {
  bearings_sf_1_9 <- line_bearing(flowlines_sf[1:5, ])
  bearings_sf_1_9 # lines of 0 length have NaN bearing
  bearings_sp_1_9 <- line_bearing(flowlines[1:5, ])
  bearings_sp_1_9
  plot(bearings_sf_1_9, bearings_sp_1_9)
  line_bearing(flowlines_sf[1:5, ], bidirectional = TRUE)
  line_bearing(flowlines[1:5, ], bidirectional = TRUE)
}
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_breakup}()},
\code{\link{line_match}()},
\code{\link{line_midpoint}()},
\code{\link{line_sample}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_sample_length}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()},
\code{\link{toptailgs}()},
\code{\link{update_line_geometry}()}
}
\concept{lines}
