% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc_temporal_catmark}
\alias{mcmc_temporal_catmark}
\title{Bayesian Estimation of Temporal Hawkes Model Parameters with Categorical Marks}
\usage{
mcmc_temporal_catmark(
  times,
  marks,
  t_max = max(times),
  t_mis = NULL,
  param_init = NULL,
  mcmc_param = NULL,
  branching = TRUE,
  print = TRUE
)
}
\arguments{
\item{times}{- vector of arrival times}

\item{marks}{- vector of marks}

\item{t_max}{- maximum time value (default = max(times))}

\item{t_mis}{- mx2 matrix, mth row contains two elements describing the mth missing time range (default = NULL)}

\item{param_init}{- list of parameters of initial guess (default = NULL, will start with MLE)}

\item{mcmc_param}{- list of mcmc parameters}

\item{branching}{- using branching structure in estimation (default = TRUE)}

\item{print}{- print progress (default = TRUE)}
}
\value{
A DataFrame containing the mcmc samples
}
\description{
This function computes the posterior of the parameters of a temporal exponential decay Hawkes model
using Metropolis-with-in-Gibbs sampling.
}
\details{
The default is to estimate the branching structure which is much more computationally efficient. The model will also account to missing data if \code{t_mis} is provided.
}
