% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{d2m}
\alias{d2m}
\title{Data-Frame to Matrix}
\usage{
d2m(
  d,
  fct = "chr",
  chr = "chr",
  lgl = "int",
  order.lvl = "alphanum",
  decreasing = FALSE,
  na.lvl = FALSE,
  check = TRUE
)
}
\arguments{
\item{d}{data.frame.}

\item{fct}{character vector of length 1 specifying what factors should be converted
to. There are three options: 1) "chr" for converting to character vectors (i.e.,
factor labels), 2) "int" for converting to integer vectors (i.e., factor codes),
or 3) "fct" for keeping the factor as is without any changes.}

\item{chr}{character vector of length 1 specifying what character vectors should
be converted to. There are three options: 1) "fct" for converting to factors (i.e.,
elements will be factor labels), 2) "int" for converting to integer vectors (i.e.,
factor codes after first converting to a factor), or 3) "chr" for keeping the
character vectors as is without any changes.}

\item{lgl}{character vector of length 1 specifying what logical vectors should
be converted to. There are four options: 1) "fct" for converting to factors (i.e.,
"TRUE" and "FALSE" will be factor labels), 2) "chr" for converting to character
vectors (i.e., elements will be "TRUE" and "FALSE"), 3) "int" for converting to
integer vectors (i.e., TRUE = 1; FALSE = 0), and 4) "lgl" for keeping the logical
vectors as is without any changes.}

\item{order.lvl}{character vector of length 1 specifying how you want to order
the levels of the factor. The options are "alphanum", which sorts the levels
alphanumerically (with NA last); "position", which sorts the levels by the position
the level first appears; "frequency", which sorts the levels by their frequency.
If any frequencies are tied, then the ties are sorted alphanumerically (with NA last).}

\item{decreasing}{logical vector of length 1 specifying whether the ordering of the
levels should be decreasing (TRUE) rather than increasing (FALSE).}

\item{na.lvl}{logical vector of length 1 specifying if NA should be considered a level.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{d} is a data.frame.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
matrix with the same dim and dimnames as \code{d}. After applying the
factor, character vector, and/or integer vector conversions through \code{d2d},
the matrix will have typeof = most complex typeof of any column in the modified
data.frame.
}
\description{
\code{d2m} converts a data.frame to a matrix. The user can specify how to convert
factors, character vectors, and integer vectors in the data.frame through the
internal use of the \code{d2d} function. After the call to \code{d2d}, \code{d2m}
simply calls \code{as.matrix.data.frame(rownames.force = TRUE)}, which will
return a matrix of the most complex typeof of any column in the data.frame
(most complex to least complex: character, double, integer, logical). Therefore,
if any factors or character vectors are left in the data.frame, it will return
a character matrix. On the other side of things, if all columns in the data.frame
are logical, then it will return a logical matrix. However, if every column in the
data.frame is logical except for one factor or character vector, then it will
return a character matrix. (If you have a data.frame where 2 columns are the matrix
dimnames and one column is the matrix elements, then use \code{d2a()}).
}
\examples{
x <- d2m(mtcars); str(x)
dat <- as.data.frame(CO2)
x <- d2m(dat); str(x)
x <- d2m(dat, fct = "int"); str(x)
}
