% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelHaplotypes.R
\name{labelHaplotypes}
\alias{labelHaplotypes}
\alias{labelHaplotypes.default}
\alias{labelHaplotypes.gtypes}
\title{Find and label haplotypes}
\usage{
labelHaplotypes(x, prefix = NULL, use.indels = TRUE)

\method{labelHaplotypes}{default}(x, prefix = NULL, use.indels = TRUE)

\method{labelHaplotypes}{gtypes}(x, ...)
}
\arguments{
\item{x}{a \code{\link{DNAbin}} \code{\link{multidna}}, or
\linkS4class{gtypes} object.}

\item{prefix}{a character string giving prefix to be applied to numbered
haplotypes. If NULL, haplotypes will be labeled with the first label
from original sequences.}

\item{use.indels}{logical. Use indels when comparing sequences?}

\item{...}{arguments to be passed to \code{labelHaplotypes.default}.}
}
\value{
For \code{DNAbin} or \code{multidna}, a list with the following elements:
 \describe{
   \item{haps}{named vector (\code{DNAbin}) or list of named vectors
     (\code{multidina}) of haplotypes for each sequence in \code{x}.}
   \item{hap.seqs}{\code{DNAbin} or \code{multidna} object containing 
     sequences for each haplotype.}
   \item{unassigned}{\code{data.frame} listing closest matching haplotypes 
     and the number of substitutions different. Will be \code{NULL} if no 
     sequences remain unassigned.}
 }
 
 For \code{gtypes}, a list with the following elements:
 \describe{
   \item{gtypes}{the new \code{gtypes} object with the haplotypes reassigned.}
   \item{unassigned}{a list containing the \code{unassigned} attribute 
     \code{data.frame} for each gene if present, otherwise \code{NULL}.}
 }
}
\description{
Identify and group sequences that share the same haplotype.
}
\details{
If any sequences contain ambiguous bases (N's) they are first
  removed. Then haplotypes are assigned based on the remaining
  sequences. The sequences with N's that were removed are then assigned to
  the new haplotypes if it can be done unambiguously (they match only one
  haplotype with 0 differences once the N's have been removed). If this
  can't be done they are assigned NAs and listed in the
  \code{unassigned} element.
}
\examples{
# create 5 example short haplotypes
haps <- c(
  H1 = "ggctagct",
  H2 = "agttagct",
  H3 = "agctggct",
  H4 = "agctggct",
  H5 = "ggttagct"
)
# draw and label 100 samples
sample.seqs <- sample(names(haps), 100, rep = TRUE)
ids <- paste(sample.seqs, 1:length(sample.seqs), sep = "_")
sample.seqs <- lapply(sample.seqs, function(x) strsplit(haps[x], "")[[1]])
names(sample.seqs) <- ids

# add some random ambiguities
with.error <- sample(1:length(sample.seqs), 10)
for(i in with.error) {
  site <- sample(1:length(sample.seqs[[i]]), 1)
  sample.seqs[[i]][site] <- "n"
}

# convert to DNAbin
library(ape)
sample.seqs <- as.DNAbin(sample.seqs)

hap.assign <- labelHaplotypes(sample.seqs, prefix = "Hap.")
hap.assign

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

