% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nopt.R
\name{nopt}
\alias{nopt}
\title{Optimal Sample Allocation in Stratified Random Sampling Scheme}
\usage{
nopt(n, N, S, M = N, method = "sa0", verbose = FALSE, variance = FALSE)
}
\arguments{
\item{n}{integer, total sample size. It must be \code{n > sum(M)}, otherwise \code{n} is truncated such that \code{n = sum(M)}, and therefore
allocation returned is equal to \code{M}. In case of truncation, the warning message is thrown.}

\item{N}{a numeric vector, strata sizes.}

\item{S}{a numeric vector, standard deviations of a study variable in strata.}

\item{M}{a numeric vector, upper bounds constraints on sample sizes in strata. It must be that \code{0 < M <= N}, where \code{N - strata sizes}.}

\item{method}{a character string indicating the algorithm to be used.
One of \emph{"sa0"} (default), \emph{"sa1"}, \emph{"coma"}, \emph{"rNa"}, can be abbreviated.}

\item{verbose}{logical, if \emph{TRUE}, more interim variables from chosen algorithm are returned.}

\item{variance}{logical, if \emph{TRUE}, the value of variance \code{D} corresponding to the optimal solution is returned.}
}
\value{
Numeric vector with optimal sample allocations in strata, or
list with numeric vector of optimal sample allocations in strata (1st element of the list), and corresponding interim variables and/or variance (further elements of the list).
}
\description{
A classical problem in survey methodology in stratified sampling schemes is an optimum sample allocation problem.
The problem is formulated as the determination of the vector (called sample allocation),
that minimizes, under given constraints, the variance of the estimator of the population total of a study variable.
For simple random sampling without replacement design in each stratum, this variance takes the following form \cr
\out{<center>}\code{D(n_1,...,n_H) = \\sum_{h = 1}^{H} \\frac{N_h^2 S_h^2}{n_h} - \\sum_{h = 1}^{H} N_h S_h^2},\out{</center>} \cr
where \code{H} denotes total number of strata, \code{N_1,...,N_H} denote strata sizes, and
\code{S_1,...,S_H} denote standard deviations of a study variable in strata. \cr

The \code{nopt} computes the \code{argmin D(n_1,...,n_H)}, under the following constraints
\out{<p style="margin-left: 40px">}\code{1: \\sum_{h=1}^{H} n_h = n} \cr
\code{2: n_h \\le M_h \\le N_h, h = 1,...,H}, \out{</p>}
where \code{n} denotes overall sample size, and \code{M_1,...,M_H} denote upper bounds optionally imposed on sample strata sizes. \cr

There are four different underlying algorithms available to use, abbreviated as: \emph{"sa0"}, \emph{"sa1"}, \emph{"coma"}, \emph{"rNa"}.
The algorithms are described in detail in Wojciak (2019). \cr
}
\examples{
nopt(n = 190, N = c(3000, 4000, 5000, 2000), S = rep(1, 4), M = c(100, 90, 70, 80))
# 40.71 54.29 67.86 27.14
nopt(n = 270, N = c(3000, 4000, 5000, 2000), S = rep(1, 4), M = c(100, 90, 70, 80))
# 66.66 88.88 70.00 44.44
nopt(n = 300, N = c(3000, 4000, 5000, 2000), S = rep(1, 4), M = c(100, 90, 70, 80))
# 84 90 70 56
nopt(n = 330, N = c(3000, 4000, 5000, 2000), S = rep(1, 4), M = c(100, 90, 70, 80))
# 100  90  70  70
nopt(n = 340, N = c(3000, 4000, 5000, 2000), S = rep(1, 4), M = c(100, 90, 70, 80))
# 100  90  70  80

\donttest{# Example of sample size n truncation, as it exceeds the sum of upper bounds, i.e. n > sum(M).
nopt(n = 350, N = c(3000, 4000, 5000, 2000), S = rep(1, 4), M = c(100, 90, 70, 80))
# 100  90  70  80}

N <- pop969[, "N"]
S <- pop969[, "S"]
n <- floor(0.01 * sum(N))
nopt(n, N, S)
nopt(n, N, S, variance = TRUE)

# Example of execution-time comparision of different algorithms using bench R package.
# nfrac <- seq(0.01, 0.9, 0.05)
# n <- setNames(nfrac * sum(N), nfrac)
# lapply(n, function(ni) bench::mark(nopt(ni, N, S, method = "sa0"),
#                                    nopt(ni, N, S, method = "sa1"),
#                                    nopt(ni, N, S, method = "coma"),
#                                    nopt(ni, N, S, method = "rNa"),
#                                    iterations = 200)[c(1,3)])

}
\references{
Wojciak W. (2019) \emph{Optimal allocation in stratified sampling schemes}.
  Master's diploma thesis, Warsaw University of Technology. \url{http://home.elka.pw.edu.pl/~wwojciak/msc_optimal_allocation.pdf} \cr
  Sarndal, C.-E., Swensson, B., and Wretman, J. (1992) \emph{Model Assisted Survey Sampling}. Chapter 3.7 \emph{Stratified Sampling}. Springer.
}
