% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms_onesided.R
\name{dopt_upper}
\alias{dopt_upper}
\alias{sga}
\alias{sgaplus}
\alias{coma}
\title{Algorithms for Optimum Sample Allocation in Stratified Sampling Under
Under One-Sided Upper Bounds Constraints}
\usage{
sga(n, a, M)

sgaplus(n, a, M)

coma(n, a, M)
}
\arguments{
\item{n}{(\code{number})\cr total sample size. A strictly positive scalar.}

\item{a}{(\code{numeric})\cr parameters \eqn{a_1, ..., a_H} of variance function
\eqn{D}. Strictly positive numbers.}

\item{M}{(\code{numeric}) \cr upper bounds constraints imposed on strata sample
sizes. It is required that \code{n <= sum(M)}. Strictly positive numbers.}
}
\value{
Numeric vector with optimal sample allocations in strata.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Internal functions that implement the optimal sample allocation algorithms:
\code{sga}, \code{sgaplus} and \code{coma}.
Functions from this family compute:
\deqn{argmin D(x_1,...,x_H) = a^2_1/x_1 + ... + a^2_H/x_H - b,}
under the equality constraint imposed on total sample size:
\deqn{x_1 + ... + x_H = n,}
and upper bounds constraints imposed on strata sample sizes:
\deqn{x_w <= M_w, w = 1,...,H.}
Here, \eqn{H} denotes total number of strata, \eqn{x_1, ..., x_H} are the
strata sample sizes, and \eqn{n > 0}, \eqn{b}, \eqn{a_w > 0},
\eqn{M_w > 0, w = 1, ..., H} are given numbers. \cr
The \code{sga()}, \code{sgaplus()} and \code{coma()} are internal implementations of the
algorithms in subject, and hence, users should not use any of these functions
directly. Instead, the \code{\link[=dopt]{dopt()}} should be used.
}
\section{Functions}{
\itemize{
\item \code{sga}: implementation of the Stenger-Gabler type algorithm
\code{SGa}, described in Wesołowski et al. (2021) and in Stenger and Gabler
(2005).

\item \code{sgaplus}: implementation of the modified Stenger-Gabler type
algorithm, described in Wójciak (2019) as
\verb{Sequential Allocation (version 1)} algorithm.

\item \code{coma}: implementation of the Change of Monotonicity
Algorithm, or \code{coma}, described in Wesołowski et al. (2021).
}}

\note{
For simple random sampling without replacement design in each stratum,
parameters of the variance function \eqn{D} are
\eqn{b = N_1 * S_1^2 + ... + N_H * S_H^2}, and \eqn{a_w = N_w * S_w}, where
\eqn{N_w, S_w, w = 1, ..., H}, are strata sizes and standard deviations of
a study variable in strata respectively.
}
\examples{
a <- c(3000, 4000, 5000, 2000)
M <- c(100, 90, 70, 80)
sga(n = 190, a = a, M = M)
sgaplus(n = 190, a = a, M = M)
coma(n = 190, a = a, M = M)
}
\references{
Wesołowski, J., Wieczorkowski, R., Wójciak, W. (2021),
Optimality of the recursive Neyman allocation,
\emph{Journal of Survey Statistics and Methodology},
\doi{10.1093/jssam/smab018},
\doi{10.48550/arXiv.2105.14486} \cr

Stenger, H., Gabler, S. (2005),
Combining random sampling and census strategies -
Justification of inclusion probabilities equal 1,
\emph{Metrika}, 61, 137-156 \cr

Wójciak, W. (2019), Optimal allocation in stratified sampling schemes,
\emph{MSc Thesis}, Warsaw University of Technology, Warsaw, Poland.
\url{http://home.elka.pw.edu.pl/~wwojciak/msc_optimal_allocation.pdf} \cr
}
\seealso{
\code{\link[=dopt]{dopt()}}, \code{\link[=rna_onesided]{rna_onesided()}}.
}
