\name{net.prox}
\alias{net.prox}
\title{Calculate Proximity Relation for Stream Segments}
\description{
 Calculate the segments that are in a specified neighborhood
 of a given segment.
}
\usage{
  net.prox (dist, seg, lag=1, direction="both")
}
\arguments{
  \item{dist}{an upstream/downstream distance matrix from
    \code{\link{net.dist}}.}
  \item{seg}{index to a segment (row number in segment
    table).  Not necessarily the segment identifier (\code{sid}),
    except that in networks generated by \code{\link{net.qmodel}}
    the index and the \code{sid} are always identical.}
  \item{lag}{distance within which neighborhood is computed,
    either in coordinates or segments (depending on how
    \code{dist} was constructed.}
  \item{direction}{\code{"up"}, \code{"down"}, or
    \code{"both"}.}
}
\details{
 This returns a vector of segments in proximity of \code{seg}
 in the direction \code{"up"}, \code{"down"}, or
 \code{"both"}.  Siblings that are in a combination of
 upstream and downstream directions are not included in
 \code{"up"} or \code{"down"}.  The distance matrix
 determines whether the neighborhood is defined by number
 of segments or by coordinates.
}
\value{A vector of segment indices.}
\author{Denis White, \email{white.denis@epa.gov} }
\seealso{
  \code{\link{net.total.dist}}
  \code{\link{net.dir}}
  \code{\link{net.prox}}
}
\examples{
  # Q model random net
  net <- net.qmodel (10)

  # add segments
  net <- net.addsegs (net)

  # distance matrix
  net.map (net, segatt=round (net$segs$length, 2))
  dmat <- net.dist (net, ends=0.5, method="coordinate")

  # proximities
  net.prox (dmat, seg=2, lag=3)
  net.prox (dmat, seg=2, lag=3, direction="up")
}
\keyword{manip}
