% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.DST}
\alias{predict.DSC}
\title{Make a Prediction for a Data Stream Mining Task}
\usage{
\method{predict}{DST}(object, newdata, ...)

\method{predict}{DSC}(
  object,
  newdata,
  type = c("auto", "micro", "macro"),
  method = "auto",
  ...
)
}
\arguments{
\item{object}{The \link{DST} object.}

\item{newdata}{The points to make predictions for as a data.frame.}

\item{...}{Additional arguments are passed on.}

\item{type}{Use micro- or macro-clusters in \link{DSC} for assignment.}

\item{method}{assignment method
\itemize{
\item \code{"model"} uses the assignment method of the underlying algorithm
(unassigned points return \code{NA}). Not all algorithms implement this option.
\item \code{"nn"} performs nearest neighbor assignment using Euclidean distance.
\item \code{"auto"} uses the model assignment method. If this method is not
implemented/available then method \code{"nn"} is used instead.
}}
}
\value{
A data.frame with columns containing the predictions. The columns depend on the type of the
data stream mining task.
}
\description{
\code{predict()} for data stream mining tasks \link{DST}.
}
\examples{
set.seed(1500)
stream <- DSD_Gaussians(k = 3, d = 2, noise = .1)

dbstream <- DSC_DBSTREAM(r = .1)
update(dbstream, stream, n = 100)
plot(dbstream, stream, type = "both")

# find the assignment for the next 100 points to
# micro-clusters in dsc. This uses the model's assignment function
points <- get_points(stream, n = 10)
points

pr <- predict(dbstream, points, type = "macro")
pr

# Note that the clusters are labeled in arbitrary order. Check the
# agreement.
agreement(pr[,".class"], points[,".class"])
}
\seealso{
Other DST: 
\code{\link{DSAggregate}()},
\code{\link{DSClassifier}()},
\code{\link{DSC}()},
\code{\link{DSOutlier}()},
\code{\link{DSRegressor}()},
\code{\link{DST_SlidingWindow}()},
\code{\link{DST_WriteStream}()},
\code{\link{DST}()},
\code{\link{evaluate}},
\code{\link{stream_pipeline}},
\code{\link{update}()}

Other DSC: 
\code{\link{DSC_Macro}()},
\code{\link{DSC_Micro}()},
\code{\link{DSC_R}()},
\code{\link{DSC_SlidingWindow}()},
\code{\link{DSC_Static}()},
\code{\link{DSC_TwoStage}()},
\code{\link{DSC}()},
\code{\link{animate_cluster}()},
\code{\link{evaluate.DSC}},
\code{\link{get_assignment}()},
\code{\link{plot.DSC}()},
\code{\link{prune_clusters}()},
\code{\link{read_saveDSC}},
\code{\link{recluster}()}
}
\author{
Michael Hahsler
}
\concept{DSC}
\concept{DST}
