/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.lazy.neighboursearch.kdtrees;

import moa.classifiers.lazy.neighboursearch.kdtrees.KDTreeNode;
import moa.classifiers.lazy.neighboursearch.kdtrees.KDTreeNodeSplitter;

public class MidPointOfWidestDimension
extends KDTreeNodeSplitter {
    private static final long serialVersionUID = -7617277960046591906L;

    public String globalInfo() {
        return "The class that splits a KDTree node based on the midpoint value of a dimension in which the node's points have the widest spread.\n\nFor more information see also:\n\n";
    }

    public void splitNode(KDTreeNode node, int numNodesCreated, double[][] nodeRanges, double[][] universe) throws Exception {
        this.correctlyInitialized();
        int splitDim = this.widestDim(nodeRanges, universe);
        double splitVal = this.m_EuclideanDistance.getMiddle(nodeRanges[splitDim]);
        int rightStart = this.rearrangePoints(this.m_InstList, node.m_Start, node.m_End, splitDim, splitVal);
        if (rightStart == node.m_Start || rightStart > node.m_End) {
            if (rightStart == node.m_Start) {
                throw new Exception("Left child is empty in node " + node.m_NodeNumber + ". Not possible with " + "MidPointofWidestDim splitting method. Please " + "check code.");
            }
            throw new Exception("Right child is empty in node " + node.m_NodeNumber + ". Not possible with " + "MidPointofWidestDim splitting method. Please " + "check code.");
        }
        node.m_SplitDim = splitDim;
        node.m_SplitValue = splitVal;
        node.m_Left = new KDTreeNode(numNodesCreated + 1, node.m_Start, rightStart - 1, this.m_EuclideanDistance.initializeRanges(this.m_InstList, node.m_Start, rightStart - 1));
        node.m_Right = new KDTreeNode(numNodesCreated + 2, rightStart, node.m_End, this.m_EuclideanDistance.initializeRanges(this.m_InstList, rightStart, node.m_End));
    }

    protected int rearrangePoints(int[] indices, int startidx, int endidx, int splitDim, double splitVal) {
        int left = startidx - 1;
        for (int i = startidx; i <= endidx; ++i) {
            if (!this.m_EuclideanDistance.valueIsSmallerEqual(this.m_Instances.instance(indices[i]), splitDim, splitVal)) continue;
            int tmp = indices[++left];
            indices[left] = indices[i];
            indices[i] = tmp;
        }
        return left + 1;
    }
}

