/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.functions;

import moa.classifiers.AbstractClassifier;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.StringUtils;
import weka.core.Instance;

public class MajorityClass
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    protected DoubleVector observedClassDistribution;

    public String getPurposeString() {
        return "Majority class classifier: always predicts the class that has been observed most frequently the in the training data.";
    }

    public void resetLearningImpl() {
        this.observedClassDistribution = new DoubleVector();
    }

    public void trainOnInstanceImpl(Instance inst) {
        this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
    }

    public double[] getVotesForInstance(Instance i) {
        return this.observedClassDistribution.getArrayCopy();
    }

    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    public void getModelDescription(StringBuilder out, int indent) {
        StringUtils.appendIndented(out, indent, "Predicted majority ");
        out.append(this.getClassNameString());
        out.append(" = ");
        out.append(this.getClassLabelString(this.observedClassDistribution.maxIndex()));
        StringUtils.appendNewline(out);
        for (int i = 0; i < this.observedClassDistribution.numValues(); ++i) {
            StringUtils.appendIndented(out, indent, "Observed weight of ");
            out.append(this.getClassLabelString(i));
            out.append(": ");
            out.append(this.observedClassDistribution.getValue(i));
            StringUtils.appendNewline(out);
        }
    }

    public boolean isRandomizable() {
        return false;
    }
}

