/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.dstream;

public class CharacteristicVector {
    private static final int SPARSE = 0;
    private static final int TRANSITIONAL = 1;
    private static final int DENSE = 2;
    private int updateTime;
    private int removeTime;
    private double gridDensity;
    private int label;
    private boolean isSporadic;
    private int attribute;
    private int densityTimeStamp;
    private boolean attChange;

    public CharacteristicVector(int tg, int tm, double D, int label, boolean status, double dl, double dm) {
        this.setUpdateTime(tg);
        this.setRemoveTime(tm);
        this.setGridDensity(D, tg);
        this.setLabel(label);
        this.setSporadic(status);
        this.attribute = this.isSparse(dl) ? 0 : (this.isDense(dm) ? 2 : 1);
        this.attChange = false;
    }

    public int getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(int updateTime) {
        this.updateTime = updateTime;
    }

    public int getRemoveTime() {
        return this.removeTime;
    }

    public void setRemoveTime(int removeTime) {
        this.removeTime = removeTime;
    }

    public double getGridDensity() {
        return this.gridDensity;
    }

    public double getCurrGridDensity(int currTime, double decayFactor) {
        return Math.pow(decayFactor, currTime - this.getUpdateTime()) * this.getGridDensity();
    }

    public void setGridDensity(double gridDensity, int timeStamp) {
        this.gridDensity = gridDensity;
        this.densityTimeStamp = timeStamp;
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int newLabel) {
        this.label = newLabel;
    }

    public boolean isSporadic() {
        return this.isSporadic;
    }

    public void setSporadic(boolean isSporadic) {
        this.isSporadic = isSporadic;
    }

    public int getDensityTimeStamp() {
        return this.densityTimeStamp;
    }

    public void setDensityTimeStamp(int densityTimeStamp) {
        this.densityTimeStamp = densityTimeStamp;
    }

    public void densityWithNew(int currTime, double decayFactor) {
        double densityOfG = this.getGridDensity();
        densityOfG = Math.pow(decayFactor, currTime - this.getUpdateTime()) * densityOfG + 1.0;
        this.setGridDensity(densityOfG, currTime);
    }

    public void updateGridDensity(int currTime, double decayFactor, double dl, double dm) {
        int lastAtt = this.getAttribute();
        double densityOfG = Math.pow(decayFactor, currTime - this.getDensityTimeStamp()) * this.getGridDensity();
        this.setGridDensity(densityOfG, currTime);
        this.attribute = this.isSparse(dl) ? 0 : (this.isDense(dm) ? 2 : 1);
        this.attChange = this.getAttribute() != lastAtt;
    }

    public boolean isDense(double dm) {
        return this.gridDensity >= dm;
    }

    public boolean isSparse(double dl) {
        return this.gridDensity <= dl;
    }

    public boolean isTransitional(double dm, double dl) {
        return !this.isDense(dm) && !this.isSparse(dl);
    }

    public int getAttribute() {
        return this.attribute;
    }

    public boolean isAttChanged() {
        return this.attChange;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("CV / A (tg tm D class status) chgflag: ");
        if (this.getAttribute() == 2) {
            sb.append("D ");
        } else if (this.getAttribute() == 0) {
            sb.append("S ");
        } else {
            sb.append("T ");
        }
        sb.append(this.getUpdateTime() + " ");
        sb.append(this.getRemoveTime() + " ");
        sb.append(this.getGridDensity() + " ");
        sb.append(this.getLabel() + " ");
        if (this.isSporadic()) {
            sb.append("Sporadic ");
        } else {
            sb.append("Normal ");
        }
        if (this.isAttChanged()) {
            sb.append("CHANGED");
        }
        return sb.toString();
    }
}

