% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_streamkm.R
\name{DSC_StreamKM}
\alias{DSC_StreamKM}
\alias{streamkm}
\alias{StreamKM}
\title{streamKM++}
\usage{
DSC_StreamKM(sizeCoreset = 10000, numClusters = 5, length = 100000L)
}
\arguments{
\item{sizeCoreset}{Size of the coreset}

\item{numClusters}{Number of clusters to compute}

\item{length}{Length of the data stream}
}
\description{
This is an interface to the MOA implementation of streamKM++.
}
\details{
streamKM++ uses a tree-based sampling strategy to obtain a small weighted sample of the stream called coreset.
Upon reclustering, the algorithm applies the k-means++ algorithm to find a given number of centres in the coreset.
}
\examples{
# data with 3 clusters
stream <- DSD_Gaussians(k=3, d=2)

# cluster with streamKM++
streamkm <- DSC_StreamKM(sizeCoreset=10000, numClusters=3, length=10000)
update(streamkm, stream, 10000)
streamkm

# plot macro-clusters
plot(streamkm, stream, type="macro")

}
\references{
Marcel R. Ackermann, Christiane Lammersen, Marcus Maertens, Christoph Raupach, Christian Sohler, Kamil Swierkot. "StreamKM++: A Clustering Algorithm for Data Streams." In: Proceedings of the 12th Workshop on Algorithm Engineering and Experiments (ALENEX '10), 2010
}
\author{
Matthias Carnein
}
