% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_ClusTree.R
\name{DSC_ClusTree}
\alias{DSC_ClusTree}
\alias{ClusTree}
\alias{clustree}
\title{ClusTree Data Stream Clusterer}
\usage{
DSC_ClusTree(horizon = 1000, maxHeight = 8, lambda = NULL, k = NULL)
}
\arguments{
\item{horizon}{Range of the (time) window.}

\item{maxHeight}{The maximum height of the tree.}

\item{lambda}{number used to override computed lambda (decay).}

\item{k}{If specified, k-means with k clusters is used for reclustering.}
}
\value{
An object of class \code{DSC_ClusTree} (subclass of \link{DSC},
\link{DSC_MOA}, \link{DSC_Micro}).
}
\description{
Interface for the MOA implementation of the ClusTree data stream clustering
algorithm (Kranen et al, 2009).
}
\details{
ClusTree uses a compact and self-adaptive index structure for maintaining
stream summaries. Kranen et al (2009) suggest EM or k-means for reclustering.
}
\examples{
# data with 3 clusters
set.seed(1000)
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)

clustree <- DSC_ClusTree(maxHeight = 3)
update(clustree, stream, 500)
clustree

plot(clustree, stream)

#' Use automatically the k-means reclusterer with k = 3 to create macro clusters
clustree <- DSC_ClusTree(maxHeight = 3, k = 3)
update(clustree, stream, 500)
clustree

plot(clustree, stream, type = "both")
}
\references{
Philipp Kranen, Ira Assent, Corinna Baldauf, and Thomas Seidl.
2009. Self-Adaptive Anytime Stream Clustering. In Proceedings of the 2009
Ninth IEEE International Conference on Data Mining (ICDM '09). IEEE Computer
Society, Washington, DC, USA, 249-258. \doi{10.1109/ICDM.2009.47}

Bifet A, Holmes G, Pfahringer B, Kranen P, Kremer H, Jansen T, Seidl T
(2010). MOA: Massive Online Analysis, a Framework for Stream Classification
and Clustering. In Journal of Machine Learning Research (JMLR).
}
\seealso{
Other DSC_MOA: 
\code{\link{DSC_BICO_MOA}()},
\code{\link{DSC_CluStream}()},
\code{\link{DSC_DStream_MOA}()},
\code{\link{DSC_DenStream}()},
\code{\link{DSC_MCOD}()},
\code{\link{DSC_MOA}()},
\code{\link{DSC_StreamKM}()}
}
\author{
Michael Hahsler and John Forrest
}
\concept{DSC_MOA}
