% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_DenStream.R
\name{DSC_DenStream}
\alias{DSC_DenStream}
\alias{DSC_DenStream_MOA}
\alias{denstream}
\alias{DenStream}
\title{DenStream Data Stream Clusterer}
\usage{
DSC_DenStream(
  epsilon,
  mu = 1,
  beta = 0.2,
  lambda = 0.001,
  initPoints = 100,
  offline = 2,
  processingSpeed = 1,
  recluster = TRUE,
  k = NULL
)
}
\arguments{
\item{epsilon}{defines the epsilon neighbourhood which is the maximal radius
of micro-clusters (r<=epsilon). Range: 0 to 1.}

\item{mu}{minpoints as the weight w a core-micro-clusters needs to be
created (w>=mu). Range: 0 to max(int).}

\item{beta}{multiplier for mu to detect outlier micro-clusters given their
weight w (w<beta x mu). Range: 0 to 1}

\item{lambda}{decay constant.}

\item{initPoints}{number of points to use for initialization via DBSCAN.}

\item{offline}{offline multiplier for epsilon. Range: between 2 and 20).
Used for reachability reclustering}

\item{processingSpeed}{Number of incoming points per time unit (important
for decay).  Range: between 1 and 1000.}

\item{recluster}{logical; should the offline DBSCAN-based (i.e.,
reachability at a distance of epsilon) be performed?}

\item{k}{integer; tries to automatically chooses offline to find k
macro-clusters.}
}
\value{
An object of class \code{DSC_DenStream} (subclass of \link{DSC},
\link{DSC_MOA}, \link{DSC_Micro}) or, for \code{recluster = TRUE}, an object
of class \link{DSC_TwoStage}.
}
\description{
Interface for the DenStream cluster algorithm for data streams implemented
in MOA.
}
\details{
DenStream applies reachbility (from DBSCAN) between micro-clusters for
reclustering using \code{epsilon} x \code{offline} (defaults to 2) as the
reachability threshold.

If \code{k} is specified it automatically chooses the reachability threshold
to find k clusters. This is achieved using single-link hierarchical
clustering.
}
\examples{
# data with 3 clusters and 5\% noise
set.seed(1000)
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)

# use Den-Stream with reachability reclustering
denstream <- DSC_DenStream(epsilon = .05)
update(denstream, stream, 500)
denstream

# plot macro-clusters
plot(denstream, stream, type = "both")

# plot micro-cluster
plot(denstream, stream, type = "micro")

# show micro and macro-clusters
plot(denstream, stream, type = "both")

# reclustering: Choose reclustering reachability threshold automatically to find 4 clusters
denstream2 <- DSC_DenStream(epsilon = .05, k = 4)
update(denstream2, stream, 500)
plot(denstream2, stream, type = "both")
}
\references{
Cao F, Ester M, Qian W, Zhou A (2006). Density-Based Clustering
over an Evolving Data Stream with Noise. In Proceedings of the 2006 SIAM
International Conference on Data Mining, pp 326-337. SIAM.

Bifet A, Holmes G, Pfahringer B, Kranen P, Kremer H, Jansen T, Seidl T
(2010).  MOA: Massive Online Analysis, a Framework for Stream Classification
and Clustering. In Journal of Machine Learning Research (JMLR).
}
\seealso{
Other DSC_MOA: 
\code{\link{DSC_BICO_MOA}()},
\code{\link{DSC_CluStream}()},
\code{\link{DSC_ClusTree}()},
\code{\link{DSC_DStream_MOA}()},
\code{\link{DSC_MCOD}()},
\code{\link{DSC_MOA}()},
\code{\link{DSC_StreamKM}()}
}
\author{
Michael Hahsler and John Forrest
}
\concept{DSC_MOA}
