% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streambugs_aux.r
\name{decode.statevarnames}
\alias{decode.statevarnames}
\title{Decode the streambugs ODE state variable names}
\usage{
decode.statevarnames(y.names)
}
\arguments{
\item{y.names}{vector with state variable names in the form of
\code{"Reach_Habitat_Taxon"} or \code{"Reach_Habitat_Taxon_Group"}}
}
\value{
List with:\describe{
   \item{\code{$y.names}}{names of state variables (input argument)}
   \item{\code{$y.reaches}, \code{$y.reaches}, \code{$y.habitats},
     \code{$y.taxa}, and \code{$y.groups}:}{Names of, respectively, reaches,
     habitats, taxa, and of groups of each state variable}
   \item{\code{$reaches}, \code{$habitats}, \code{$taxa}, \code{$groups}:}{
     Unique names of, respectively, reaches, habitats, taxa, and of groups of
     state variables}
   \item{\code{$ind.fA}:}{Indices used for the areal fractions of each reach
     and habitat}
   }
}
\description{
Extract reach names, habitat names, taxa names and optional group names from
encoded labels of streambugs ODE state variable names.
}
\examples{
y.names <- c("Reach1_Hab1_Baetis_Invertebrates","Reach1_Hab1_Ecdyonurus_Invertebrates",
             "Reach2_Hab1_Baetis_Invertebrates", "Reach2_Hab1_Ecdyonurus_Invertebrates")
decode.statevarnames(y.names)

}
