% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ecxsys.R, R/plot_stress.R,
%   R/plot_survival.R
\name{plot_ecxsys}
\alias{plot_ecxsys}
\alias{plot_stress}
\alias{plot_survival}
\title{Plot the results of the ECx-SyS model}
\usage{
plot_stress(
  model,
  which = NA,
  show_legend = FALSE,
  xlab = "concentration",
  ylab = "stress",
  main = NULL
)

plot_survival(
  model,
  which = NA,
  show_legend = FALSE,
  xlab = "concentration",
  ylab = "survival",
  main = NULL
)
}
\arguments{
\item{model}{The object returned from \code{\link{ecxsys}}.}

\item{which}{A vector of names to plot. Allowed are the column names of the
\code{model$curves} data frame. There is also
\code{"survival_tox_observed"} and \code{"survival_tox_env_observed"} for
the observed survival and \code{"sys_tox_observed"} and
\code{"sys_tox_env_observed"} for the observed Sys. The default \code{NA}
only plots the most important curves. Use \code{which = "all"} to display
all curves. An empty vector or \code{NULL} creates just the axes.}

\item{show_legend}{Should the plot include a legend? Defaults to \code{FALSE}
because it may cover some parts of the plot depending on the plot size and
the number of elements shown.}

\item{xlab, ylab, main}{Axis labels and title.}
}
\value{
None
}
\description{
Plot the observed and modeled survivals and stresses.
}
\examples{
model <- ecxsys(
    concentration = c(0, 0.05, 0.5, 5, 30),
    hormesis_concentration = 0.5,
    survival_tox_observed = c(90, 81, 92, 28, 0),
    survival_tox_env_observed = c(29, 27, 33, 5, 0)
)
plot_survival(model, show_legend = TRUE)
plot_stress(model, show_legend = TRUE)

# Plot all curves:
plot_survival(model, which = "all")
plot_stress(model, which = "all")

# Plot only some selected curves:
plot_survival(model, which = c("survival_tox_sys", "survival_tox_env_sys"))
plot_stress(model, which = c("sys_tox", "sys_tox_env"))

# Plot only the observed values:
plot_survival(model, which = c("survival_tox_observed", "survival_tox_env_observed"))
plot_stress(model, which = c("sys_tox_observed", "sys_tox_env_observed"))
}
