#' Boston Housing Data
#'
#' A subset of data from the Housing data for 506 census tracts of Boston from
#'  the 1970 Census. Original data set can be found in the
#'  \link[mlbench:BostonHousing2]{mlbench} package.
#'
#' @usage data(boston)
#' @format
#' A data.frame with 506 rows and 13 columns:
#' \describe{
#'   \item{cmedv}{corrected median value of owner-occupied homes in USD 1000's}
#'   \item{crim}{per capita crime rate by town}
#'   \item{zn}{proportion of residential land zoned for lots over 25,000 sq.ft}
#'   \item{indus}{proportion of non-retail business acres per town}
#'   \item{nox}{nitric oxides concentration (parts per 10 million)}
#'   \item{rm}{average number of rooms per dwelling}
#'   \item{age}{proportion of owner-occupied units built prior to 1940}
#'   \item{dis}{weighted distances to five Boston employment centres}
#'   \item{rad}{index of accessibility to radial highways}
#'   \item{tax}{full-value property-tax rate per USD 10,000}
#'   \item{ptratio}{pupil-teacher ratio by town}
#'   \item{chas}{Charles River dummy variable (= 1 if tract bounds river; 0 otherwise)}
#'   \item{lstat}{percentage of lower status of the population}
#' }
#' @name boston
#' @source mlbench package
"boston"
