% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_locate_boundaries}
\alias{stri_locate_boundaries}
\title{Locate Specific Text Boundaries}
\usage{
stri_locate_boundaries(str, boundary = "word", locale = NULL)
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{boundary}{character vector, each string is one of \code{character},
\code{line-break}, \code{sentence}, or \code{word}}

\item{locale}{\code{NULL} or \code{""} for text boundary analysis following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale}.}
}
\value{
A list of \code{max(length(str), length(boundary))} integer matrices
is returned. The first column gives the start positions
of substrings between located boundaries, and the second column gives
the end positions. The indices are code point-based, thus
they may be passed e.g. to the \code{\link{stri_sub}} function.

Moreover, you may get two \code{NA}s in one row
for no match or \code{NA} arguments.
}
\description{
This function locates specific text boundaries
(like character, word, line, or sentence boundaries)
and splits strings at the indicated positions.
}
\details{
Vectorized over \code{str} and \code{boundary}.

For more information on the text boundary analysis
performed by \pkg{ICU}'s \code{BreakIterator}, see
\code{\link{stri_locate_boundaries}}.

For locating words in a text using \pkg{ICU}'s word iterator,
see \code{\link{stri_locate_words}}.
}
\examples{
stri_locate_boundaries("The\\u00a0above-mentioned packages are...", boundary='line')
}
\seealso{
Other indexing: \code{\link{stri_locate_all_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_last_charclass}},
  \code{\link{stri_locate_last_charclass}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_locate_all_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_last_regex}},
  \code{\link{stri_locate_last_regex}};
  \code{\link{stri_locate_all}};
  \code{\link{stri_locate_first}};
  \code{\link{stri_locate_last}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_locate}}; \code{\link{stri_sub}},
  \code{\link{stri_sub<-}}

Other locale_sensitive: \code{\link{\%!==\%}},
  \code{\link{\%!=\%}}, \code{\link{\%<=\%}},
  \code{\link{\%<\%}}, \code{\link{\%===\%}},
  \code{\link{\%==\%}}, \code{\link{\%>=\%}},
  \code{\link{\%>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_coll}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-coll}}

Other search_locate: \code{\link{stri_locate_all_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_last_charclass}},
  \code{\link{stri_locate_last_charclass}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_locate_all_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_last_regex}},
  \code{\link{stri_locate_last_regex}};
  \code{\link{stri_locate_all}};
  \code{\link{stri_locate_first}};
  \code{\link{stri_locate_last}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_locate}}; \code{\link{stringi-search}}

Other text_boundaries: \code{\link{stri_extract_words}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_wrap}}
}

