% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_extract_all_coll}
\alias{stri_extract_all_coll}
\alias{stri_extract_first_coll}
\alias{stri_extract_last_coll}
\title{Extract Canonically Equivalent Pattern Matches}
\usage{
stri_extract_all_coll(str, pattern, opts_collator = NULL)

stri_extract_first_coll(str, pattern, opts_collator = NULL)

stri_extract_last_coll(str, pattern, opts_collator = NULL)
}
\arguments{
\item{str}{character vector}

\item{pattern}{character vector}

\item{opts_collator}{a named list with \pkg{ICU} Collator's settings
as generated with \code{\link{stri_opts_collator}}; \code{NULL}
for default settings}
}
\value{
For \code{stri_extract_all_coll}, a list of
\code{max(length(str), length(pattern))} character vectors is returned.
Otherwise, you get a character vector.
\code{NA} if not found.
}
\description{
These functions extract substrings of \code{str} that
match a given \code{pattern}.
}
\details{
Vectorized over \code{str} and \code{pattern}.

There are locale-sensitive operations.
See \link{stringi-search-coll} for more details on
locale-sensitive text searching in \pkg{stringi}.
}
\examples{
stri_extract_all_coll(c('AaaaaaaA', 'AAAA'), 'a')
stri_extract_first_coll(c('Yy\\u00FD', 'AAA'), 'y',
   stri_opts_collator(strength=2, locale="sk_SK"))
stri_extract_last_coll(c('Yy\\u00FD', 'AAA'), 'y',
   stri_opts_collator(strength=1, locale="sk_SK"))
}
\seealso{
Other locale_sensitive: \code{\link{\%!==\%}},
  \code{\link{\%!=\%}}, \code{\link{\%<=\%}},
  \code{\link{\%<\%}}, \code{\link{\%===\%}},
  \code{\link{\%==\%}}, \code{\link{\%>=\%}},
  \code{\link{\%>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_coll}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-coll}}

Other search_coll: \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_coll}};
  \code{\link{stringi-search-coll}};
  \code{\link{stringi-search}}

Other search_extract: \code{\link{stri_extract_all_charclass}},
  \code{\link{stri_extract_first_charclass}},
  \code{\link{stri_extract_first_charclass}},
  \code{\link{stri_extract_last_charclass}},
  \code{\link{stri_extract_last_charclass}};
  \code{\link{stri_extract_all_regex}},
  \code{\link{stri_extract_first_regex}},
  \code{\link{stri_extract_first_regex}},
  \code{\link{stri_extract_last_regex}},
  \code{\link{stri_extract_last_regex}};
  \code{\link{stri_extract_all}};
  \code{\link{stri_extract_first}};
  \code{\link{stri_extract_last}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_extract}}; \code{\link{stringi-search}}
}

